/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.utils;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;

public class SqlValidatorUtils {
    public static void adjustTypeForArrayConstructor(RelDataType componentType, SqlOperatorBinding opBinding) {
        if (opBinding instanceof SqlCallBinding) {
            SqlValidatorUtils.adjustTypeForMultisetConstructor(componentType, componentType, (SqlCallBinding)opBinding);
        }
    }

    public static void adjustTypeForMapConstructor(Pair<RelDataType, RelDataType> componentType, SqlOperatorBinding opBinding) {
        if (opBinding instanceof SqlCallBinding) {
            SqlValidatorUtils.adjustTypeForMultisetConstructor(componentType.getKey(), componentType.getValue(), (SqlCallBinding)opBinding);
        }
    }

    private static void adjustTypeForMultisetConstructor(RelDataType evenType, RelDataType oddType, SqlCallBinding sqlCallBinding) {
        SqlCall call = sqlCallBinding.getCall();
        List<RelDataType> operandTypes = sqlCallBinding.collectOperandTypes();
        List<SqlNode> operands = call.getOperandList();
        for (int i = 0; i < operands.size(); ++i) {
            RelDataType elementType = i % 2 == 0 ? evenType : oddType;
            if (operandTypes.get(i).equalsSansFieldNames(elementType)) continue;
            call.setOperand(i, SqlValidatorUtils.castTo(operands.get(i), elementType));
        }
    }

    private static SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(type).withNullable(type.isNullable()));
    }
}

