/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rex.RexLiteral;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.ValuesCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.runtime.operators.values.ValuesInputFormat;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public abstract class CommonExecValues
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String VALUES_TRANSFORMATION = "values";
    public static final String FIELD_NAME_TUPLES = "tuples";
    private final List<List<RexLiteral>> tuples;

    public CommonExecValues(int id, ExecNodeContext context, ReadableConfig persistedConfig, List<List<RexLiteral>> tuples, RowType outputType, String description) {
        super(id, context, persistedConfig, Collections.emptyList(), (LogicalType)outputType, description);
        this.tuples = tuples;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ValuesInputFormat inputFormat = ValuesCodeGenerator.generatorInputFormat(config.getTableConfig(), (RowType)this.getOutputType(), this.tuples, this.getClass().getSimpleName());
        Transformation transformation = planner.getExecEnv().createInput((InputFormat)inputFormat, (TypeInformation)inputFormat.getProducedType()).getTransformation();
        this.createTransformationMeta(VALUES_TRANSFORMATION, config).fill(transformation);
        transformation.setParallelism(1);
        transformation.setMaxParallelism(1);
        return transformation;
    }

    @JsonProperty(value="tuples")
    public List<List<RexLiteral>> getTuples() {
        return this.tuples;
    }
}

