/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
final class AggregateCallJsonSerializer
extends StdSerializer<AggregateCall> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_NAME = "name";
    static final String FIELD_NAME_ARG_LIST = "argList";
    static final String FIELD_NAME_FILTER_ARG = "filterArg";
    static final String FIELD_NAME_DISTINCT = "distinct";
    static final String FIELD_NAME_APPROXIMATE = "approximate";
    static final String FIELD_NAME_IGNORE_NULLS = "ignoreNulls";
    static final String FIELD_NAME_TYPE = "type";

    AggregateCallJsonSerializer() {
        super(AggregateCall.class);
    }

    public void serialize(AggregateCall aggCall, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ReadableConfig config = SerdeContext.get((DatabindContext)serializerProvider).getConfiguration();
        TableConfigOptions.CatalogPlanCompilation compilationStrategy = (TableConfigOptions.CatalogPlanCompilation)config.get(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(FIELD_NAME_NAME, aggCall.getName());
        RexNodeJsonSerializer.serializeSqlOperator(aggCall.getAggregation(), jsonGenerator, serializerProvider, compilationStrategy == TableConfigOptions.CatalogPlanCompilation.ALL);
        jsonGenerator.writeFieldName(FIELD_NAME_ARG_LIST);
        jsonGenerator.writeStartArray();
        for (int arg : aggCall.getArgList()) {
            jsonGenerator.writeNumber(arg);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeNumberField(FIELD_NAME_FILTER_ARG, aggCall.filterArg);
        jsonGenerator.writeBooleanField(FIELD_NAME_DISTINCT, aggCall.isDistinct());
        jsonGenerator.writeBooleanField(FIELD_NAME_APPROXIMATE, aggCall.isApproximate());
        jsonGenerator.writeBooleanField(FIELD_NAME_IGNORE_NULLS, aggCall.ignoreNulls());
        serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)aggCall.getType(), jsonGenerator);
        jsonGenerator.writeEndObject();
    }
}

