/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSpecBase;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DynamicTableSinkSpec
extends DynamicTableSpecBase {
    public static final String FIELD_NAME_CATALOG_TABLE = "table";
    public static final String FIELD_NAME_SINK_ABILITIES = "abilities";
    private final ContextResolvedTable contextResolvedTable;
    @Nullable
    private final List<SinkAbilitySpec> sinkAbilities;
    private DynamicTableSink tableSink;

    @JsonCreator
    public DynamicTableSinkSpec(@JsonProperty(value="table") ContextResolvedTable contextResolvedTable, @Nullable @JsonProperty(value="abilities") List<SinkAbilitySpec> sinkAbilities) {
        this.contextResolvedTable = contextResolvedTable;
        this.sinkAbilities = sinkAbilities;
    }

    @JsonGetter(value="table")
    public ContextResolvedTable getContextResolvedTable() {
        return this.contextResolvedTable;
    }

    @JsonGetter(value="abilities")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public List<SinkAbilitySpec> getSinkAbilities() {
        return this.sinkAbilities;
    }

    public DynamicTableSink getTableSink(FlinkContext flinkContext) {
        if (this.tableSink == null) {
            DynamicTableSinkFactory factory = flinkContext.getModuleManager().getFactory(Module::getTableSinkFactory).orElse(null);
            this.tableSink = FactoryUtil.createDynamicTableSink((DynamicTableSinkFactory)factory, (ObjectIdentifier)this.contextResolvedTable.getIdentifier(), (ResolvedCatalogTable)((ResolvedCatalogTable)this.contextResolvedTable.getResolvedTable()), this.loadOptionsFromCatalogTable(this.contextResolvedTable, flinkContext), (ReadableConfig)flinkContext.getTableConfig(), (ClassLoader)flinkContext.getClassLoader(), (boolean)this.contextResolvedTable.isTemporary());
            if (this.sinkAbilities != null) {
                this.sinkAbilities.forEach(spec -> spec.apply(this.tableSink));
            }
        }
        return this.tableSink;
    }

    public void setTableSink(DynamicTableSink tableSink) {
        this.tableSink = tableSink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicTableSinkSpec that = (DynamicTableSinkSpec)o;
        return Objects.equals(this.contextResolvedTable, that.contextResolvedTable) && Objects.equals(this.sinkAbilities, that.sinkAbilities) && Objects.equals(this.tableSink, that.tableSink);
    }

    public int hashCode() {
        return Objects.hash(this.contextResolvedTable, this.sinkAbilities, this.tableSink);
    }

    public String toString() {
        return "DynamicTableSinkSpec{contextResolvedTable=" + this.contextResolvedTable + ", sinkAbilities=" + this.sinkAbilities + ", tableSink=" + this.tableSink + '}';
    }
}

