/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.channel.AbstractChannel;
import org.apache.flume.instrumentation.ChannelCounter;

public class PseudoTxnMemoryChannel
extends AbstractChannel {
    private static final Integer defaultCapacity = 50;
    private static final Integer defaultKeepAlive = 3;
    private BlockingQueue<Event> queue;
    private Integer keepAlive;
    private ChannelCounter channelCounter;

    @Override
    public void configure(Context context) {
        Integer capacity = context.getInteger("capacity");
        this.keepAlive = context.getInteger("keep-alive");
        if (capacity == null) {
            capacity = defaultCapacity;
        }
        if (this.keepAlive == null) {
            this.keepAlive = defaultKeepAlive;
        }
        this.queue = new ArrayBlockingQueue<Event>(capacity);
        if (this.channelCounter == null) {
            this.channelCounter = new ChannelCounter(this.getName());
        }
    }

    @Override
    public void start() {
        this.channelCounter.start();
        this.channelCounter.setChannelSize(this.queue.size());
        this.channelCounter.setChannelSize(this.queue.size() + this.queue.remainingCapacity());
        super.start();
    }

    @Override
    public void stop() {
        this.channelCounter.setChannelSize(this.queue.size());
        this.channelCounter.stop();
        super.stop();
    }

    @Override
    public void put(Event event) {
        Preconditions.checkState((this.queue != null ? 1 : 0) != 0, (Object)"No queue defined (Did you forget to configure me?");
        this.channelCounter.incrementEventPutAttemptCount();
        try {
            this.queue.put(event);
        }
        catch (InterruptedException ex) {
            throw new ChannelException("Failed to put(" + event + ")", ex);
        }
        this.channelCounter.addToEventPutSuccessCount(1L);
        this.channelCounter.setChannelSize(this.queue.size());
    }

    @Override
    public Event take() {
        Preconditions.checkState((this.queue != null ? 1 : 0) != 0, (Object)"No queue defined (Did you forget to configure me?");
        this.channelCounter.incrementEventTakeAttemptCount();
        try {
            Event e = this.queue.poll(this.keepAlive.intValue(), TimeUnit.SECONDS);
            this.channelCounter.addToEventTakeSuccessCount(1L);
            this.channelCounter.setChannelSize(this.queue.size());
            return e;
        }
        catch (InterruptedException ex) {
            throw new ChannelException("Failed to take()", ex);
        }
    }

    @Override
    public Transaction getTransaction() {
        return NoOpTransaction.sharedInstance();
    }

    public static class NoOpTransaction
    implements Transaction {
        private static NoOpTransaction sharedInstance;

        public static Transaction sharedInstance() {
            if (sharedInstance == null) {
                sharedInstance = new NoOpTransaction();
            }
            return sharedInstance;
        }

        @Override
        public void begin() {
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void close() {
        }
    }
}

