/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.ThrowingJobGraphWriter;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class JobDispatcherLeaderProcess
extends AbstractDispatcherLeaderProcess {
    private final AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherGatewayServiceFactory;
    @Nullable
    private final JobGraph jobGraph;
    @Nullable
    private final JobResult recoveredDirtyJobResult;
    private final JobResultStore jobResultStore;

    JobDispatcherLeaderProcess(UUID leaderSessionId, AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherGatewayServiceFactory, @Nullable JobGraph jobGraph, @Nullable JobResult recoveredDirtyJobResult, JobResultStore jobResultStore, FatalErrorHandler fatalErrorHandler) {
        super(leaderSessionId, fatalErrorHandler);
        this.dispatcherGatewayServiceFactory = dispatcherGatewayServiceFactory;
        this.jobGraph = jobGraph;
        this.recoveredDirtyJobResult = recoveredDirtyJobResult;
        this.jobResultStore = (JobResultStore)Preconditions.checkNotNull((Object)jobResultStore);
    }

    @Override
    protected void onStart() {
        AbstractDispatcherLeaderProcess.DispatcherGatewayService dispatcherService = this.dispatcherGatewayServiceFactory.create(DispatcherId.fromUuid(this.getLeaderSessionId()), CollectionUtil.ofNullable((Object)this.jobGraph), CollectionUtil.ofNullable((Object)this.recoveredDirtyJobResult), ThrowingJobGraphWriter.INSTANCE, this.jobResultStore);
        this.completeDispatcherSetup(dispatcherService);
    }
}

