/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.List;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.slf4j.Logger;

class Canceling
extends StateWithExecutionGraph {
    private final StateWithExecutionGraph.Context context;

    Canceling(StateWithExecutionGraph.Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, ClassLoader userCodeClassLoader, List<ExceptionHistoryEntry> failureCollection) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger, userCodeClassLoader, failureCollection);
        this.context = context;
        this.getExecutionGraph().cancel();
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.CANCELLING;
    }

    @Override
    public void cancel() {
    }

    @Override
    void onFailure(Throwable failure) {
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.getExecutionGraph()));
    }

    static class Factory
    implements StateFactory<Canceling> {
        private final StateWithExecutionGraph.Context context;
        private final Logger log;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final ClassLoader userCodeClassLoader;
        private final List<ExceptionHistoryEntry> failureCollection;

        public Factory(StateWithExecutionGraph.Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger log, ClassLoader userCodeClassLoader, List<ExceptionHistoryEntry> failureCollection) {
            this.context = context;
            this.log = log;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.userCodeClassLoader = userCodeClassLoader;
            this.failureCollection = failureCollection;
        }

        @Override
        public Class<Canceling> getStateClass() {
            return Canceling.class;
        }

        @Override
        public Canceling getState() {
            return new Canceling(this.context, this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.log, this.userCodeClassLoader, this.failureCollection);
        }
    }
}

