/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.commons.admin;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServiceRegister {
    public static final Logger LOG = LoggerFactory.getLogger(AdminServiceRegister.class);

    public static void register(String type, String name, Object mbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String beanName = "org.apache.inlong:type=" + type + ',' + "name" + '=' + name;
        LOG.info("start to register mbean:{}", (Object)beanName);
        try {
            ObjectName objName = new ObjectName(beanName);
            mbs.registerMBean(mbean, objName);
            LOG.info("end to register mbean:{}", (Object)beanName);
        }
        catch (Exception ex) {
            LOG.error("exception while register mbean:{},error:{}", new Object[]{beanName, ex.getMessage(), ex});
        }
    }

    public static void main(String[] args) {
        String type = "type1";
        String name = "name1";
        String beanName = "org.apache.inlong:type=" + type + ',' + "name" + '=' + name;
        try {
            ObjectName objName = new ObjectName(beanName);
            System.out.println(objName.toString());
            System.out.println(objName.getCanonicalKeyPropertyListString());
            System.out.println(objName.getCanonicalName());
            System.out.println(objName.getKeyProperty("name"));
        }
        catch (Exception ex) {
            LOG.error("exception while register mbean:{},error:{}", new Object[]{beanName, ex.getMessage(), ex});
        }
    }
}

