/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;

@JsonTypeName(value="splitIndex")
public class SplitIndexFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 460250096378706646L;
    @JsonProperty(value="field")
    private FieldInfo field;
    @JsonProperty(value="separator")
    private StringConstantParam separator;
    @JsonProperty(value="index")
    private ConstantParam index;

    public SplitIndexFunction(@JsonProperty(value="field") FieldInfo field, @JsonProperty(value="separator") StringConstantParam separator, @JsonProperty(value="index") ConstantParam index) {
        this.field = (FieldInfo)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.separator = (StringConstantParam)Preconditions.checkNotNull((Object)separator, (Object)"separator is null");
        this.index = (ConstantParam)Preconditions.checkNotNull((Object)index, (Object)"index is null");
    }

    @Override
    public String getName() {
        return "SPLIT_INDEX";
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.field, this.separator, this.index);
    }

    @Override
    public String format() {
        return String.format("%s(%s, %s, %s)", this.getName(), this.field.format(), this.separator.format(), this.index.format());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitIndexFunction)) {
            return false;
        }
        SplitIndexFunction other = (SplitIndexFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldInfo this$field = this.getField();
        FieldInfo other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        StringConstantParam this$separator = this.getSeparator();
        StringConstantParam other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !((Object)this$separator).equals(other$separator)) {
            return false;
        }
        ConstantParam this$index = this.getIndex();
        ConstantParam other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !((Object)this$index).equals(other$index));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplitIndexFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldInfo $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        StringConstantParam $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : ((Object)$separator).hashCode());
        ConstantParam $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        return result;
    }

    public FieldInfo getField() {
        return this.field;
    }

    public StringConstantParam getSeparator() {
        return this.separator;
    }

    public ConstantParam getIndex() {
        return this.index;
    }

    public void setField(FieldInfo field) {
        this.field = field;
    }

    public void setSeparator(StringConstantParam separator) {
        this.separator = separator;
    }

    public void setIndex(ConstantParam index) {
        this.index = index;
    }

    public String toString() {
        return "SplitIndexFunction(field=" + this.getField() + ", separator=" + this.getSeparator() + ", index=" + this.getIndex() + ")";
    }
}

