/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort;

import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.pojo.sort.ClusterTagConfig;
import org.apache.inlong.common.pojo.sort.node.NodeConfig;
import org.apache.inlong.common.util.SortConfigUtil;

public class TaskConfig
implements Serializable {
    private String sortTaskName;
    private List<ClusterTagConfig> clusterTagConfigs;
    private NodeConfig nodeConfig;

    public static List<TaskConfig> batchCheckDelete(List<TaskConfig> last, List<TaskConfig> current) {
        return SortConfigUtil.batchCheckDeleteRecursive(last, current, TaskConfig::getSortTaskName, TaskConfig::checkDelete);
    }

    public static List<TaskConfig> batchCheckUpdate(List<TaskConfig> last, List<TaskConfig> current) {
        return SortConfigUtil.batchCheckUpdateRecursive(last, current, TaskConfig::getSortTaskName, TaskConfig::checkUpdate);
    }

    public static List<TaskConfig> batchCheckNew(List<TaskConfig> last, List<TaskConfig> current) {
        return SortConfigUtil.batchCheckNewRecursive(last, current, TaskConfig::getSortTaskName, TaskConfig::checkNew);
    }

    public static List<TaskConfig> batchCheckLatest(List<TaskConfig> latest, List<TaskConfig> current) {
        return SortConfigUtil.batchCheckLatestRecursive(latest, current, TaskConfig::getSortTaskName, TaskConfig::checkLatest);
    }

    public static TaskConfig checkDelete(TaskConfig last, TaskConfig current) {
        return TaskConfig.check(last, current, ClusterTagConfig::batchCheckDelete, (lastNode, currentNode) -> lastNode);
    }

    public static TaskConfig checkUpdate(TaskConfig last, TaskConfig current) {
        return TaskConfig.check(last, current, ClusterTagConfig::batchCheckUpdate, (lastNode, currentNode) -> {
            if (lastNode == null || currentNode == null) {
                return null;
            }
            return lastNode.getVersion() < currentNode.getVersion() ? null : currentNode;
        });
    }

    public static TaskConfig checkNew(TaskConfig last, TaskConfig current) {
        return TaskConfig.check(last, current, ClusterTagConfig::batchCheckNew, (lastNode, currentNode) -> {
            if (lastNode == null || currentNode == null) {
                return null;
            }
            return lastNode.getVersion() >= currentNode.getVersion() ? lastNode : currentNode;
        });
    }

    public static TaskConfig checkLatest(TaskConfig last, TaskConfig current) {
        return TaskConfig.check(last, current, ClusterTagConfig::batchCheckLatest, (lastNode, currentNode) -> {
            if (lastNode == null || currentNode == null) {
                return null;
            }
            return lastNode.getVersion() >= currentNode.getVersion() ? lastNode : currentNode;
        });
    }

    public static TaskConfig check(TaskConfig last, TaskConfig current, BiFunction<List<ClusterTagConfig>, List<ClusterTagConfig>, List<ClusterTagConfig>> clusterCheckFunction, BiFunction<NodeConfig, NodeConfig, NodeConfig> nodeCheckFunction) {
        List<ClusterTagConfig> checkClusterTags = clusterCheckFunction.apply(last.getClusterTagConfigs(), current.getClusterTagConfigs());
        NodeConfig checkNode = nodeCheckFunction.apply(last.getNodeConfig(), current.getNodeConfig());
        if (CollectionUtils.isEmpty(checkClusterTags) && checkNode == null) {
            return null;
        }
        return TaskConfig.builder().sortTaskName(last.getSortTaskName()).clusterTagConfigs(checkClusterTags).nodeConfig(checkNode).build();
    }

    public static TaskConfigBuilder builder() {
        return new TaskConfigBuilder();
    }

    public String getSortTaskName() {
        return this.sortTaskName;
    }

    public List<ClusterTagConfig> getClusterTagConfigs() {
        return this.clusterTagConfigs;
    }

    public NodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public void setSortTaskName(String sortTaskName) {
        this.sortTaskName = sortTaskName;
    }

    public void setClusterTagConfigs(List<ClusterTagConfig> clusterTagConfigs) {
        this.clusterTagConfigs = clusterTagConfigs;
    }

    public void setNodeConfig(NodeConfig nodeConfig) {
        this.nodeConfig = nodeConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskConfig)) {
            return false;
        }
        TaskConfig other = (TaskConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sortTaskName = this.getSortTaskName();
        String other$sortTaskName = other.getSortTaskName();
        if (this$sortTaskName == null ? other$sortTaskName != null : !this$sortTaskName.equals(other$sortTaskName)) {
            return false;
        }
        List<ClusterTagConfig> this$clusterTagConfigs = this.getClusterTagConfigs();
        List<ClusterTagConfig> other$clusterTagConfigs = other.getClusterTagConfigs();
        if (this$clusterTagConfigs == null ? other$clusterTagConfigs != null : !((Object)this$clusterTagConfigs).equals(other$clusterTagConfigs)) {
            return false;
        }
        NodeConfig this$nodeConfig = this.getNodeConfig();
        NodeConfig other$nodeConfig = other.getNodeConfig();
        return !(this$nodeConfig == null ? other$nodeConfig != null : !((Object)this$nodeConfig).equals(other$nodeConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sortTaskName = this.getSortTaskName();
        result = result * 59 + ($sortTaskName == null ? 43 : $sortTaskName.hashCode());
        List<ClusterTagConfig> $clusterTagConfigs = this.getClusterTagConfigs();
        result = result * 59 + ($clusterTagConfigs == null ? 43 : ((Object)$clusterTagConfigs).hashCode());
        NodeConfig $nodeConfig = this.getNodeConfig();
        result = result * 59 + ($nodeConfig == null ? 43 : ((Object)$nodeConfig).hashCode());
        return result;
    }

    public String toString() {
        return "TaskConfig(sortTaskName=" + this.getSortTaskName() + ", clusterTagConfigs=" + this.getClusterTagConfigs() + ", nodeConfig=" + this.getNodeConfig() + ")";
    }

    public TaskConfig(String sortTaskName, List<ClusterTagConfig> clusterTagConfigs, NodeConfig nodeConfig) {
        this.sortTaskName = sortTaskName;
        this.clusterTagConfigs = clusterTagConfigs;
        this.nodeConfig = nodeConfig;
    }

    public TaskConfig() {
    }

    public static class TaskConfigBuilder {
        private String sortTaskName;
        private List<ClusterTagConfig> clusterTagConfigs;
        private NodeConfig nodeConfig;

        TaskConfigBuilder() {
        }

        public TaskConfigBuilder sortTaskName(String sortTaskName) {
            this.sortTaskName = sortTaskName;
            return this;
        }

        public TaskConfigBuilder clusterTagConfigs(List<ClusterTagConfig> clusterTagConfigs) {
            this.clusterTagConfigs = clusterTagConfigs;
            return this;
        }

        public TaskConfigBuilder nodeConfig(NodeConfig nodeConfig) {
            this.nodeConfig = nodeConfig;
            return this;
        }

        public TaskConfig build() {
            return new TaskConfig(this.sortTaskName, this.clusterTagConfigs, this.nodeConfig);
        }

        public String toString() {
            return "TaskConfig.TaskConfigBuilder(sortTaskName=" + this.sortTaskName + ", clusterTagConfigs=" + this.clusterTagConfigs + ", nodeConfig=" + this.nodeConfig + ")";
        }
    }
}

