/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.http.HttpMethod;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContextBuilder;

public class SecurityContext {
    private final List<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
    private final Predicate<String> selector;
    private final Predicate<HttpMethod> methodSelector;
    private final Predicate<OperationContext> operationSelector;

    public SecurityContext(List<SecurityReference> securityReferences, Predicate<String> selector, Predicate<HttpMethod> methodSelector, Predicate<OperationContext> operationSelector) {
        this.securityReferences.addAll(securityReferences);
        this.selector = selector;
        this.methodSelector = methodSelector;
        this.operationSelector = operationSelector;
    }

    public List<SecurityReference> securityForOperation(OperationContext operationContext) {
        if (this.operationSelector == null ? this.selector.test(operationContext.requestMappingPattern()) && this.methodSelector.test(operationContext.httpMethod()) : this.operationSelector.test(operationContext)) {
            return this.securityReferences;
        }
        return new ArrayList<SecurityReference>();
    }

    public static SecurityContextBuilder builder() {
        return new SecurityContextBuilder();
    }
}

