/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.inlong.sort.formats.metrics.IncrementGauge;
import org.apache.inlong.sort.formats.metrics.gauge.EventTimeDelayGauge;

public class FormatMetricGroup
extends ProxyMetricGroup<MetricGroup> {
    public static final String FORMAT_GROUP_NAME = "format";
    private Counter numRecordsSerializeError;
    private Gauge<?> numRecordsSerializeErrorDiff;
    private Counter numRecordsSerializeErrorIgnored;
    private Gauge<?> numRecordsSerializeErrorIgnoredDiff;
    private Counter numRecordsDeserializeError;
    private Gauge<?> numRecordsDeserializeErrorDiff;
    private Counter numRecordsDeserializeErrorIgnored;
    private Gauge<?> numRecordsDeserializeErrorIgnoredDiff;
    @Deprecated
    private EventTimeDelayGauge eventTimeDelayMillis;
    private final Map<String, String> tags;

    public FormatMetricGroup(OperatorMetricGroup parent, boolean isDeserializer) {
        this(parent, "", isDeserializer);
    }

    public FormatMetricGroup(OperatorMetricGroup parent, String name, boolean isDeserializer) {
        this(parent, name, isDeserializer, Collections.emptyMap());
    }

    public FormatMetricGroup(OperatorMetricGroup parent, String name, boolean isDeserializer, Map<String, String> tags) {
        super(parent.addGroup(name, StringUtils.join((Object[])new Map[]{tags})));
        this.tags = tags;
        if (isDeserializer) {
            this.eventTimeDelayMillis = (EventTimeDelayGauge)this.gauge("eventDelayTime", new EventTimeDelayGauge());
            this.numRecordsDeserializeError = this.counter("numRecordsDeserializeError");
            this.numRecordsDeserializeErrorIgnored = this.counter("numRecordsDeserializeErrorIgnored");
            this.numRecordsDeserializeErrorDiff = this.gauge("numRecordsDeserializeErrorDiff", new IncrementGauge(this.numRecordsDeserializeError));
            this.numRecordsDeserializeErrorIgnoredDiff = this.gauge("numRecordsDeserializeErrorIgnoredDiff", new IncrementGauge(this.numRecordsDeserializeErrorIgnored));
        } else {
            this.numRecordsSerializeError = this.counter("numRecordsSerializeError");
            this.numRecordsSerializeErrorIgnored = this.counter("numRecordsSerializeErrorIgnored");
            this.numRecordsSerializeErrorDiff = this.gauge("numRecordsSerializeErrorDiff", new IncrementGauge(this.numRecordsSerializeError));
            this.numRecordsSerializeErrorIgnoredDiff = this.gauge("numRecordsSerializeErrorIgnoredDiff", new IncrementGauge(this.numRecordsSerializeErrorIgnored));
        }
    }

    public Map<String, String> getAllVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            variables.put(ScopeFormat.asVariable((String)entry.getKey()), entry.getValue());
        }
        variables.putAll(this.parentMetricGroup.getAllVariables());
        return variables;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Counter getNumRecordsSerializeError() {
        return this.numRecordsSerializeError;
    }

    public Counter getNumRecordsSerializeErrorIgnored() {
        return this.numRecordsSerializeErrorIgnored;
    }

    public Counter getNumRecordsDeserializeError() {
        return this.numRecordsDeserializeError;
    }

    public Counter getNumRecordsDeserializeErrorIgnored() {
        return this.numRecordsDeserializeErrorIgnored;
    }

    public EventTimeDelayGauge getEventTimeDelayMillis() {
        return this.eventTimeDelayMillis;
    }

    public Gauge<?> getNumRecordsSerializeErrorDiff() {
        return this.numRecordsSerializeErrorDiff;
    }

    public Gauge<?> getNumRecordsSerializeErrorIgnoredDiff() {
        return this.numRecordsSerializeErrorIgnoredDiff;
    }

    public Gauge<?> getNumRecordsDeserializeErrorDiff() {
        return this.numRecordsDeserializeErrorDiff;
    }

    public Gauge<?> getNumRecordsDeserializeErrorIgnoredDiff() {
        return this.numRecordsDeserializeErrorIgnoredDiff;
    }
}

