/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.cluster.ClusterConfigService;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Cluster-Config-API"})
public class ClusterConfigController {
    @Autowired
    private ClusterConfigService clusterConfigService;

    @PostMapping(value={"/clusterConfig/refresh/{clusterTag}"})
    @ApiOperation(value="Refresh cluster config")
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> refresh(@PathVariable String clusterTag) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterConfigService.refresh(clusterTag, currentUser));
    }
}

