/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.consume.SortConsumerInfo;
import org.apache.inlong.manager.service.maintenanceTools.MaintenanceToolsService;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Maintenanct tools-API"})
public class MaintenanceToolsController {
    @Autowired
    private MaintenanceToolsService maintenanceToolsService;

    @PostMapping(value={"/maintenanceTools/getSortConsumer"})
    @ApiOperation(value="get sort consumer info")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="file object", required=true, dataType="__FILE", dataTypeClass=MultipartFile.class, paramType="query")})
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<List<SortConsumerInfo>> getSortConsumer(@RequestParam(value="file") MultipartFile file) {
        return Response.success((Object)this.maintenanceToolsService.getSortConsumer(file));
    }

    @PostMapping(value={"/maintenanceTools/resetCursor"})
    @ApiOperation(value="reset cursor consumer")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="file object", required=true, dataType="__FILE", dataTypeClass=MultipartFile.class, paramType="query"), @ApiImplicitParam(name="resetTime", dataTypeClass=String.class, required=true)})
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> resetCursor(@RequestParam(value="file") MultipartFile file, @RequestParam(value="resetTime") String resetTime) {
        return Response.success((Object)this.maintenanceToolsService.resetCursor(file, resetTime));
    }
}

