/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

class OracleEventMetadataProvider
implements EventMetadataProvider {
    OracleEventMetadataProvider() {
    }

    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Long timestamp = sourceInfo.getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        String scn = sourceInfo.getString("scn");
        return Collect.hashMapOf((Object)"scn", (Object)(scn == null ? "null" : scn));
    }

    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        return sourceInfo.getString("txId");
    }
}

