/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.SinkInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PbSinkInfo
extends SinkInfo {
    private List<FieldInfo> fields;
    private String protoDescription;

    public PbSinkInfo(@JsonProperty(value="charset") String charset, @JsonProperty(value="protoDescription") String protoDescription, @JsonProperty(value="fields") List<FieldInfo> fields) {
        super("pb", charset);
        if (CollectionUtils.isEmpty(fields)) {
            throw new IllegalArgumentException("failed to init pb sink info, fieldInfos is empty");
        }
        this.protoDescription = protoDescription;
        this.fields = fields;
    }

    @JsonProperty(value="fields")
    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldInfo> fields) {
        this.fields = fields;
    }

    @JsonProperty(value="protoDescription")
    public String getProtoDescription() {
        return this.protoDescription;
    }

    public void setProtoDescription(String protoDescription) {
        this.protoDescription = protoDescription;
    }

    protected PbSinkInfo(PbSinkInfoBuilder<?, ?> b) {
        super(b);
        this.fields = ((PbSinkInfoBuilder)b).fields;
        this.protoDescription = ((PbSinkInfoBuilder)b).protoDescription;
    }

    public static PbSinkInfoBuilder<?, ?> builder() {
        return new PbSinkInfoBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PbSinkInfo)) {
            return false;
        }
        PbSinkInfo other = (PbSinkInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldInfo> this$fields = this.getFields();
        List<FieldInfo> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$protoDescription = this.getProtoDescription();
        String other$protoDescription = other.getProtoDescription();
        return !(this$protoDescription == null ? other$protoDescription != null : !this$protoDescription.equals(other$protoDescription));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PbSinkInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldInfo> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $protoDescription = this.getProtoDescription();
        result = result * 59 + ($protoDescription == null ? 43 : $protoDescription.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PbSinkInfo(fields=" + this.getFields() + ", protoDescription=" + this.getProtoDescription() + ")";
    }

    private static final class PbSinkInfoBuilderImpl
    extends PbSinkInfoBuilder<PbSinkInfo, PbSinkInfoBuilderImpl> {
        private PbSinkInfoBuilderImpl() {
        }

        @Override
        protected PbSinkInfoBuilderImpl self() {
            return this;
        }

        @Override
        public PbSinkInfo build() {
            return new PbSinkInfo(this);
        }
    }

    public static abstract class PbSinkInfoBuilder<C extends PbSinkInfo, B extends PbSinkInfoBuilder<C, B>>
    extends SinkInfo.SinkInfoBuilder<C, B> {
        private List<FieldInfo> fields;
        private String protoDescription;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B fields(List<FieldInfo> fields) {
            this.fields = fields;
            return (B)this.self();
        }

        public B protoDescription(String protoDescription) {
            this.protoDescription = protoDescription;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PbSinkInfo.PbSinkInfoBuilder(super=" + super.toString() + ", fields=" + this.fields + ", protoDescription=" + this.protoDescription + ")";
        }
    }
}

