/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"hex"}, parameter="(String dataStr)", descriptions={"- Return \"\" if dataStr is NULL;", "- Return the string obtained by converting the dataStr to hexadecimal if 'dataStr' can be parsed into numeric;", "- Return the string obtained by converting the ASCII code corresponding to each character to hexadecimal otherwise."}, examples={"hex(1007) = \"3EF\"", "hex('abc') = \"616263\""})
public class HexFunction
implements ValueParser {
    private static final Pattern BIG_DECIMAL_PATTERN = Pattern.compile("^[-+]?\\d+(\\.\\d+)?([eE][-+]?\\d+)?$");
    private ValueParser valueParser;

    public HexFunction(net.sf.jsqlparser.expression.Function expr) {
        this.valueParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object valueObj = this.valueParser.parse(sourceData, rowIndex, context);
        if (this.isBigDecimal(valueObj)) {
            return this.hex(OperatorTools.parseBigDecimal(valueObj)).toUpperCase();
        }
        return this.hex(OperatorTools.parseString(valueObj)).toUpperCase();
    }

    private boolean isBigDecimal(Object valueObj) {
        if (valueObj instanceof BigDecimal) {
            return true;
        }
        if (valueObj instanceof String) {
            String str = (String)valueObj;
            return BIG_DECIMAL_PATTERN.matcher(str).matches();
        }
        return false;
    }

    private String hex(int number) {
        return Integer.toHexString(number).toUpperCase();
    }

    private String hex(long number) {
        return Long.toHexString(number).toUpperCase();
    }

    private String hex(String input) {
        StringBuilder hexString = new StringBuilder();
        for (char c : input.toCharArray()) {
            hexString.append(Integer.toHexString(c).toUpperCase());
        }
        return hexString.toString();
    }

    private String hex(BigDecimal number) {
        BigDecimal integerValue = number.setScale(0, RoundingMode.DOWN);
        return this.tryConvert(integerValue, BigDecimal::intValueExact, this::hex).orElseGet(() -> this.tryConvert(integerValue, BigDecimal::longValueExact, this::hex).orElseThrow(() -> new IllegalArgumentException("Number out of range")));
    }

    private <T> Optional<String> tryConvert(BigDecimal number, Function<BigDecimal, T> converter, Function<T, String> handler) {
        try {
            T value = converter.apply(number);
            return Optional.ofNullable(handler.apply(value));
        }
        catch (ArithmeticException e) {
            return Optional.empty();
        }
    }
}

