/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"min_scale"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if 'numeric' is NULL;", "- Return minimum scale (number of fractional decimal digits) needed to represent the supplied value precisely."}, examples={"min_scale(3.1415000000000) = 4"})
public class MinScaleFunction
implements ValueParser {
    private final ValueParser numParser;

    public MinScaleFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.numParser = OperatorTools.buildParser((Expression)expressions.get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numObj = this.numParser.parse(sourceData, rowIndex, context);
        if (numObj == null) {
            return null;
        }
        return OperatorTools.parseBigDecimal(numObj).stripTrailingZeros().scale();
    }
}

