/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import java.util.Random;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"rand"}, parameter="(Integer seed)", descriptions={"- Return a pseudo-random double precision value in the range [0.0, 1.0) if seed is NULL;", "- Return a pseudo-random double precision value in the range [0.0, 1.0) with an initial 'seed' of Integer."}, examples={"rand(1)", "rand()"})
public class RandFunction
implements ValueParser {
    private ValueParser seedParser;
    private Random random = new Random();

    public RandFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() == 1) {
            this.seedParser = OperatorTools.buildParser((Expression)expressions.get(0));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.seedParser != null) {
            Object seedObj = this.seedParser.parse(sourceData, rowIndex, context);
            BigDecimal seedValue = OperatorTools.parseBigDecimal(seedObj);
            this.random.setSeed(seedValue.intValue());
        }
        return this.random.nextDouble();
    }
}

