/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_concat"}, parameter="([Array array1, Array array2, ...])", descriptions={"- Return \"\" if any input array is NULL;", "- Return an array that is the result of concatenating at least one array."}, examples={"array_concat(array('he',7),array('xxd', 'cloud')) = [he, 7, xxd, cloud]"})
public class ArrayConcatFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public ArrayConcatFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        ArrayList res = new ArrayList();
        for (ValueParser valueParser : this.parserList) {
            Object parseObj = valueParser.parse(sourceData, rowIndex, context);
            if (parseObj == null) {
                return null;
            }
            if (!(parseObj instanceof ArrayList)) continue;
            ArrayList array = (ArrayList)parseObj;
            if (array.isEmpty()) {
                return null;
            }
            res.addAll(array);
        }
        return res;
    }
}

