/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.Arrays;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"map_values"}, parameter="(Map map)", descriptions={"- Return \"\" if 'map' is null;", "- Return the values of the 'map' as array. No order guaranteed."}, examples={"map_values(Map('he',1,'xxd','cloud')) = [1, cloud]", "map_values(Map('xxd','cloud',map(1,2),map(3,'apple'))) = [cloud, {3=apple}]"})
public class MapValueFunction
implements ValueParser {
    private final ValueParser mapParser;

    public MapValueFunction(Function expr) {
        this.mapParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object mapObj = this.mapParser.parse(sourceData, rowIndex, context);
        if (mapObj == null) {
            return null;
        }
        if (mapObj instanceof Map) {
            Map map = (Map)mapObj;
            if (map.isEmpty()) {
                return null;
            }
            return Arrays.toString(map.values().toArray());
        }
        return null;
    }
}

