/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_arrays"}, parameter="([String value1, String value2, ...])", descriptions={"- Return a JSON array string constructed from a list of values."}, examples={"JSON_ARRAYS() = []", "JSON_ARRAYS(1, '2') = [1,\"2\"]", "JSON_ARRAYS(JSON_ARRAY(1)) = [[1]]"})
public class JsonArraysFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public JsonArraysFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        JSONArray jsonArray = new JSONArray();
        for (ValueParser valueParser : this.parserList) {
            Object parseObj = valueParser.parse(sourceData, rowIndex, context);
            if (parseObj instanceof String && this.isJsonArray((String)parseObj)) {
                jsonArray.add((Object)JSON.parseArray((String)((String)parseObj)));
                continue;
            }
            jsonArray.add(parseObj);
        }
        return jsonArray.toJSONString();
    }

    private boolean isJsonArray(String jsonStr) {
        try {
            JSON.parseArray((String)jsonStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

