/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_exists"}, parameter="(String json_doc, String path)", descriptions={"- Return true if 'json_doc' satisfies a given 'path' search criterion;", "- Return false otherwise."}, examples={"JSON_EXISTS('{\"a\": true}', '$.a') = true", "JSON_EXISTS('{\"a\": true}', '$.b') = false", "JSON_EXISTS('{\"a\": [{ \"b\": 1 }]}', '$.a[0].b') = true"})
public class JsonExistsFunction
implements ValueParser {
    private final ValueParser jsonParser;
    private final ValueParser pathParser;

    public JsonExistsFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonObj = this.jsonParser.parse(sourceData, rowIndex, context);
        Object pathObj = this.pathParser.parse(sourceData, rowIndex, context);
        if (jsonObj == null || pathObj == null) {
            return false;
        }
        String path = OperatorTools.parseString(pathObj);
        String jsonString = OperatorTools.parseString(jsonObj);
        if (path.isEmpty()) {
            return false;
        }
        Object json = JSON.parse((String)jsonString);
        if (json == null) {
            return false;
        }
        return JSONPath.contains((Object)json, (String)path);
    }
}

