/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"initcap", "init_cap"}, parameter="(String s1, String s2)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return a new form of 'str' with the first character of each word converted to uppercase and the rest characters to lowercase."}, examples={"initcap('hello world') = \"Hello world\""})
public class InitCapFunction
implements ValueParser {
    private ValueParser stringParser;

    public InitCapFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object strObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (strObject == null) {
            return null;
        }
        String str = OperatorTools.parseString(strObject);
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : str.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                if (capitalizeNext) {
                    result.append(Character.toUpperCase(c));
                    capitalizeNext = false;
                    continue;
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            capitalizeNext = true;
            result.append(c);
        }
        return result.toString();
    }
}

