/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.nio.charset.StandardCharsets;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"soundex"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return a four character code representing the sound of 'str'."}, examples={"soundex('hello world') = \"H464\""})
public class SoundexFunction
implements ValueParser {
    private ValueParser stringParser;
    private static final byte[] SOUNDEX_INDEX = "71237128722455712623718272\u0000\u0000\u0000\u0000\u0000\u000071237128722455712623718272".getBytes(StandardCharsets.ISO_8859_1);

    public SoundexFunction(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        String str = OperatorTools.parseString(stringObject);
        if (str == null) {
            return null;
        }
        return new String(SoundexFunction.getSoundex(str), StandardCharsets.ISO_8859_1);
    }

    private static byte[] getSoundex(String str) {
        byte[] chars = new byte[]{48, 48, 48, 48};
        byte lastDigit = 48;
        int j = 0;
        int l = str.length();
        for (int i = 0; i < l && j < 4; ++i) {
            byte newDigit;
            char c = str.charAt(i);
            if (c < 'A' || c > 'z' || (newDigit = SOUNDEX_INDEX[c - 65]) == 0) continue;
            if (j == 0) {
                chars[j++] = (byte)(c & 0xDF);
                lastDigit = newDigit;
                continue;
            }
            if (newDigit <= 54) {
                if (newDigit == lastDigit) continue;
                chars[j++] = lastDigit = newDigit;
                continue;
            }
            if (newDigit != 55) continue;
            lastDigit = newDigit;
        }
        return chars;
    }
}

