/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"substring_index"}, parameter="(String str, String delim, Integer count)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return everything to the left of the last count occurrences of 'delim' (counting from the left), if 'count' is positive;", "- Return everything to the right of the last count occurrences of 'delim' (counting from the right) if 'count' is negative."}, examples={"SUBSTRING_INDEX('AA. ',' ',1) = \"AA.\""})
public class SubstringIndexFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser delimParser;
    private ValueParser countParser;

    public SubstringIndexFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.delimParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.countParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object delimObj = this.delimParser.parse(sourceData, rowIndex, context);
        Object countObj = this.countParser.parse(sourceData, rowIndex, context);
        if (stringObj == null || delimObj == null || countObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObj);
        String delim = OperatorTools.parseString(delimObj);
        int count = OperatorTools.parseBigDecimal(countObj).intValue();
        if (str.isEmpty() || delim.isEmpty() || count == 0) {
            return "";
        }
        boolean isRight = count < 0;
        count = Math.abs(count);
        ArrayList<Integer> startIndexList = this.findStart(delim, str);
        int size = startIndexList.size();
        if (size < count) {
            return str;
        }
        if (isRight) {
            int start = startIndexList.get(size - count);
            return str.substring(start + delim.length());
        }
        int start = startIndexList.get(count - 1);
        return str.substring(0, start);
    }

    public ArrayList<Integer> findStart(String patten, String str) {
        int i;
        ArrayList<Integer> next = new ArrayList<Integer>();
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        next.add(0);
        int j = 0;
        for (i = 1; i < patten.length(); ++i) {
            while (j > 0 && patten.charAt(i) != patten.charAt(j)) {
                j = (Integer)next.get(j - 1);
            }
            if (patten.charAt(i) == patten.charAt(j)) {
                ++j;
            }
            next.add(j);
        }
        j = 0;
        for (i = 0; i < str.length(); ++i) {
            while (j > 0 && str.charAt(i) != patten.charAt(j)) {
                j = (Integer)next.get(j - 1);
            }
            if (str.charAt(i) == patten.charAt(j)) {
                ++j;
            }
            if (j != patten.length()) continue;
            startIndexList.add(i - patten.length() + 1);
            j = 0;
        }
        return startIndexList;
    }
}

