/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"to_timestamp"}, parameter="(String str [,String format])", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the result of converting the date and time string 'str' to the 'format' (by default: yyyy-MM-dd HH:mm:ss if not specified) under the 'UTC+0' time zone to a timestamp."}, examples={"to_timestamp('1970/01/01 00:00:44', 'yyyy/MM/dd HH:mm:ss') = \"1970-01-01 00:00:44.0\""})
public class ToTimestampFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser formatParser;
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public ToTimestampFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() == 2) {
            this.formatParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        LocalDateTime dateTime;
        String dateString = OperatorTools.parseString(this.stringParser.parse(sourceData, rowIndex, context));
        String formatPattern = this.formatParser != null ? OperatorTools.parseString(this.formatParser.parse(sourceData, rowIndex, context)) : DEFAULT_FORMAT;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
        try {
            dateTime = LocalDateTime.parse(dateString, formatter);
        }
        catch (DateTimeParseException e) {
            LocalDate date = LocalDate.parse(dateString, formatter);
            dateTime = LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        long utcMillis = dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        Timestamp timestamp = new Timestamp(utcMillis);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S").withZone(ZoneId.of("UTC"));
        return outputFormatter.format(timestamp.toInstant());
    }
}

