/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.instance;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.core.instance.ActionType;
import org.apache.inlong.agent.core.instance.InstanceAction;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Instance;
import org.apache.inlong.agent.store.InstanceStore;
import org.apache.inlong.agent.store.Store;
import org.apache.inlong.agent.store.TaskStore;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceManager.class);
    private static final int ACTION_QUEUE_CAPACITY = 100;
    public volatile int CORE_THREAD_SLEEP_TIME_MS = 1000;
    public static final int INSTANCE_PRINT_INTERVAL_MS = 10000;
    public static final long INSTANCE_KEEP_ALIVE_MS = 300000L;
    public static final long KEEP_PACE_INTERVAL_MS = 60000L;
    private long lastPrintTime = 0L;
    private long lastTraverseTime = 0L;
    private final InstanceStore instanceStore;
    private TaskStore taskStore;
    private TaskProfile taskFromStore;
    private final ConcurrentHashMap<String, Instance> instanceMap;
    private final BlockingQueue<InstanceAction> actionQueue;
    private final BlockingQueue<InstanceAction> addActionQueue;
    private final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("instance-manager"));
    private final int instanceLimit;
    private final AgentConfiguration agentConf;
    private final String taskId;
    private long auditVersion;
    private volatile boolean running = false;
    private final double reserveCoefficient = 0.8;
    protected TaskManager taskManager;
    private final int globalInstanceLimit;

    public InstanceManager(TaskManager taskManager, String taskId, int instanceLimit, Store basicStore, TaskStore taskStore) {
        this.taskManager = taskManager;
        this.taskId = taskId;
        this.instanceStore = new InstanceStore(basicStore);
        this.taskStore = taskStore;
        this.agentConf = AgentConfiguration.getAgentConf();
        this.instanceMap = new ConcurrentHashMap();
        this.instanceLimit = instanceLimit;
        this.actionQueue = new LinkedBlockingQueue<InstanceAction>(100);
        this.addActionQueue = new LinkedBlockingQueue<InstanceAction>(100);
        this.globalInstanceLimit = this.agentConf.getInt("agent.instance.limit", 100);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public InstanceStore getInstanceStore() {
        return this.instanceStore;
    }

    public Instance getInstance(String instanceId) {
        return this.instanceMap.get(instanceId);
    }

    public InstanceProfile getInstanceProfile(String instanceId) {
        return this.instanceStore.getInstance(this.taskId, instanceId);
    }

    public boolean submitAction(InstanceAction action) {
        if (action == null) {
            return false;
        }
        if (action.getActionType() == ActionType.ADD && this.isFull()) {
            return false;
        }
        return this.actionQueue.offer(action);
    }

    private Runnable coreThread() {
        return () -> {
            Thread.currentThread().setName("instance-manager-core-" + this.taskId);
            this.running = true;
            while (this.isRunnable()) {
                long currentTime = AgentUtils.getCurrentTime();
                try {
                    AgentUtils.silenceSleepInMs((long)this.CORE_THREAD_SLEEP_TIME_MS);
                    this.printInstanceState();
                    this.dealWithActionQueue();
                    this.dealWithAddActionQueue();
                    if (currentTime - this.lastTraverseTime > 60000L) {
                        this.keepPaceWithStore();
                        this.lastTraverseTime = currentTime;
                    }
                    String inlongGroupId = this.taskFromStore.getInlongGroupId();
                    String inlongStreamId = this.taskFromStore.getInlongStreamId();
                    AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_INSTANCE_MGR_HEARTBEAT, (String)inlongGroupId, (String)inlongStreamId, (long)AgentUtils.getCurrentTime(), (int)1, (long)1L, (long)this.auditVersion);
                }
                catch (Throwable ex) {
                    LOGGER.error("coreThread error: ", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
            this.running = false;
        };
    }

    private void printInstanceState() {
        long currentTime = AgentUtils.getCurrentTime();
        if (currentTime - this.lastPrintTime > 10000L) {
            List instances = this.instanceStore.getInstances(this.taskId);
            InstancePrintStat stat = new InstancePrintStat();
            for (int i = 0; i < instances.size(); ++i) {
                InstanceProfile instance = (InstanceProfile)instances.get(i);
                stat.stat(instance.getState());
            }
            LOGGER.info("instanceManager running! taskId {} mem {} total {} {} action count {}", new Object[]{this.taskId, this.instanceMap.size(), instances.size(), stat, this.actionQueue.size()});
            this.lastPrintTime = currentTime;
        }
    }

    private void keepPaceWithStore() {
        this.traverseStoreTasksToMemory();
        this.traverseMemoryTasksToStore();
    }

    private void traverseStoreTasksToMemory() {
        this.instanceStore.getInstances(this.taskId).forEach(profileFromStore -> {
            InstanceStateEnum storeState = profileFromStore.getState();
            Instance instance = this.instanceMap.get(profileFromStore.getInstanceId());
            switch (storeState) {
                case DEFAULT: {
                    if (instance != null) break;
                    LOGGER.info("traverseStoreTasksToMemory add instance to mem taskId {} instanceId {}", (Object)profileFromStore.getTaskId(), (Object)profileFromStore.getInstanceId());
                    this.addToMemory((InstanceProfile)profileFromStore);
                    break;
                }
                case FINISHED: {
                    if (instance == null) break;
                    LOGGER.info("traverseStoreTasksToMemory delete instance from mem taskId {} instanceId {}", (Object)profileFromStore.getTaskId(), (Object)profileFromStore.getInstanceId());
                    this.deleteFromMemory(profileFromStore.getInstanceId());
                    break;
                }
                default: {
                    LOGGER.error("instance invalid state {} taskId {} instanceId {}", new Object[]{storeState, profileFromStore.getTaskId(), profileFromStore.getInstanceId()});
                }
            }
        });
    }

    private void traverseMemoryTasksToStore() {
        this.instanceMap.values().forEach(instance -> {
            InstanceProfile profileFromStore = this.instanceStore.getInstance(instance.getTaskId(), instance.getInstanceId());
            if (profileFromStore == null) {
                this.deleteFromMemory(instance.getInstanceId());
                return;
            }
            InstanceStateEnum stateFromStore = profileFromStore.getState();
            if (stateFromStore != InstanceStateEnum.DEFAULT) {
                this.deleteFromMemory(instance.getInstanceId());
            }
            if (AgentUtils.getCurrentTime() - instance.getLastHeartbeatTime() > 300000L) {
                LOGGER.error("instance heartbeat timeout, id: {}, will be deleted from memory", (Object)instance.getInstanceId());
                this.deleteFromMemory(instance.getInstanceId());
            }
        });
    }

    private void dealWithActionQueue() {
        block7: while (this.isRunnable()) {
            try {
                InstanceAction action = (InstanceAction)this.actionQueue.poll();
                if (action == null) break;
                switch (action.getActionType()) {
                    case ADD: {
                        if (this.addActionQueue.offer(action)) continue block7;
                        LOGGER.error("it should never happen: addQueue is full");
                        continue block7;
                    }
                    case FINISH: {
                        this.finishInstance(action.getProfile());
                        continue block7;
                    }
                    case DELETE: {
                        this.deleteInstance(action.getProfile().getInstanceId());
                        continue block7;
                    }
                }
                LOGGER.error("invalid action type for instance manager: taskId {} type {}", (Object)this.taskId, (Object)action.getActionType());
            }
            catch (Throwable ex) {
                LOGGER.error("dealWithActionQueue", ex);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            }
        }
    }

    private void dealWithAddActionQueue() {
        while (this.isRunnable()) {
            if (this.taskManager != null && this.taskManager.getInstanceNum() > this.globalInstanceLimit) {
                LOGGER.error("global instance num {} over limit {}", (Object)this.taskManager.getInstanceNum(), (Object)this.globalInstanceLimit);
                return;
            }
            if (this.instanceMap.size() > this.instanceLimit) {
                LOGGER.error("task {} instanceMap size {} over limit {}", new Object[]{this.taskId, this.instanceMap.size(), this.instanceLimit});
                return;
            }
            InstanceAction action = (InstanceAction)this.addActionQueue.poll();
            if (action == null) break;
            this.addInstance(action.getProfile());
        }
    }

    public void start() {
        this.restoreFromStore();
        this.submitWorker(this.coreThread());
    }

    public void stop() {
        this.waitForTerminate();
        this.stopAllInstances();
    }

    public void waitForTerminate() {
        super.waitForTerminate();
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)this.CORE_THREAD_SLEEP_TIME_MS);
        }
    }

    private void restoreFromStore() {
        this.taskFromStore = this.taskStore.getTask(this.taskId);
        this.auditVersion = Long.parseLong(this.taskFromStore.get("task.auditVersion"));
        List profileList = this.instanceStore.getInstances(this.taskId);
        profileList.forEach(profile -> {
            InstanceStateEnum state = profile.getState();
            if (state == InstanceStateEnum.DEFAULT) {
                LOGGER.info("instance restoreFromStore addToMem state {} taskId {} instanceId {}", new Object[]{state, this.taskId, profile.getInstanceId()});
                profile.setBoolean("task.restoreFromDB", true);
                this.addToMemory((InstanceProfile)profile);
            } else {
                LOGGER.info("instance restoreFromStore ignore state {} taskId {} instanceId {}", new Object[]{state, this.taskId, profile.getInstanceId()});
            }
        });
    }

    private void addInstance(InstanceProfile profile) {
        LOGGER.info("add instance taskId {} instanceId {}", (Object)this.taskId, (Object)profile.getInstanceId());
        if (!this.shouldAddAgain(profile.getInstanceId(), profile.getFileUpdateTime())) {
            LOGGER.info("addInstance shouldAddAgain returns false skip taskId {} instanceId {}", (Object)this.taskId, (Object)profile.getInstanceId());
            return;
        }
        this.addToStore(profile, true);
        this.addToMemory(profile);
    }

    private void finishInstance(InstanceProfile profile) {
        profile.setState(InstanceStateEnum.FINISHED);
        profile.setModifyTime(Long.valueOf(AgentUtils.getCurrentTime()));
        this.addToStore(profile, false);
        this.deleteFromMemory(profile.getInstanceId());
        LOGGER.info("finished instance state {} taskId {} instanceId {}", new Object[]{profile.getState(), profile.getTaskId(), profile.getInstanceId()});
    }

    private void deleteInstance(String instanceId) {
        this.deleteFromStore(instanceId);
        this.deleteFromMemory(instanceId);
    }

    private void deleteFromStore(String instanceId) {
        InstanceProfile profile = this.instanceStore.getInstance(this.taskId, instanceId);
        if (profile == null) {
            LOGGER.error("try to delete instance from store but not found: taskId {} instanceId {}", (Object)this.taskId, (Object)instanceId);
            return;
        }
        String inlongGroupId = profile.getInlongGroupId();
        String inlongStreamId = profile.getInlongStreamId();
        this.instanceStore.deleteInstance(this.taskId, instanceId);
        LOGGER.info("delete instance from instance store: taskId {} instanceId {} result {}", new Object[]{this.taskId, instanceId, this.instanceStore.getInstance(this.taskId, instanceId)});
        AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_DEL_INSTANCE_DB, (String)inlongGroupId, (String)inlongStreamId, (long)profile.getSinkDataTime(), (int)1, (long)1L, (long)this.auditVersion);
    }

    private void deleteFromMemory(String instanceId) {
        Instance instance = this.instanceMap.get(instanceId);
        if (instance == null) {
            LOGGER.error("try to delete instance from memory but not found: taskId {} instanceId {}", (Object)this.taskId, (Object)instanceId);
            return;
        }
        String inlongGroupId = instance.getProfile().getInlongGroupId();
        String inlongStreamId = instance.getProfile().getInlongStreamId();
        instance.destroy();
        this.instanceMap.remove(instanceId);
        LOGGER.info("delete instance from memory: taskId {} instanceId {}", (Object)this.taskId, (Object)instance.getInstanceId());
        AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_DEL_INSTANCE_MEM, (String)inlongGroupId, (String)inlongStreamId, (long)instance.getProfile().getSinkDataTime(), (int)1, (long)1L, (long)this.auditVersion);
    }

    private void notifyDestroyInstance(String instanceId) {
        Instance instance = this.instanceMap.get(instanceId);
        if (instance == null) {
            LOGGER.error("try to notify destroy instance but not found: taskId {} instanceId {}", (Object)this.taskId, (Object)instanceId);
            return;
        }
        instance.notifyDestroy();
    }

    private void addToStore(InstanceProfile profile, boolean addNew) {
        LOGGER.info("add instance to instance store state {} instanceId {}", (Object)profile.getState(), (Object)profile.getInstanceId());
        this.instanceStore.storeInstance(profile);
        if (addNew) {
            String inlongGroupId = profile.getInlongGroupId();
            String inlongStreamId = profile.getInlongStreamId();
            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_ADD_INSTANCE_DB, (String)inlongGroupId, (String)inlongStreamId, (long)profile.getSinkDataTime(), (int)1, (long)1L, (long)this.auditVersion);
        }
    }

    private void addToMemory(InstanceProfile instanceProfile) {
        String inlongGroupId = instanceProfile.getInlongGroupId();
        String inlongStreamId = instanceProfile.getInlongStreamId();
        Instance oldInstance = this.instanceMap.get(instanceProfile.getInstanceId());
        if (oldInstance != null) {
            oldInstance.destroy();
            this.instanceMap.remove(instanceProfile.getInstanceId());
            LOGGER.error("old instance {} should not exist, try stop it first", (Object)instanceProfile.getInstanceId());
            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_DEL_INSTANCE_MEM_UNUSUAL, (String)inlongGroupId, (String)inlongStreamId, (long)instanceProfile.getSinkDataTime(), (int)1, (long)1L, (long)this.auditVersion);
        }
        LOGGER.info("instanceProfile {}", (Object)instanceProfile.toJsonStr());
        try {
            if (this.taskManager != null && this.taskManager.getInstanceNum() > this.globalInstanceLimit) {
                LOGGER.error("global instance num {} over limit {}", (Object)this.taskManager.getInstanceNum(), (Object)this.globalInstanceLimit);
                return;
            }
            if (this.instanceMap.size() > this.instanceLimit) {
                LOGGER.info("add instance to memory refused because instanceMap size over limit {}", (Object)instanceProfile.getInstanceId());
                return;
            }
            Class<?> taskClass = Class.forName(instanceProfile.getInstanceClass());
            Instance instance = (Instance)taskClass.newInstance();
            boolean initSuc = instance.init((Object)this, instanceProfile);
            if (initSuc) {
                this.instanceMap.put(instanceProfile.getInstanceId(), instance);
                this.EXECUTOR_SERVICE.submit((Runnable)instance);
                LOGGER.info("add instance to memory instanceId {} instanceMap size {}, runningPool instance total {}, runningPool instance active {}", new Object[]{instance.getInstanceId(), this.instanceMap.size(), this.EXECUTOR_SERVICE.getTaskCount(), this.EXECUTOR_SERVICE.getActiveCount()});
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_ADD_INSTANCE_MEM, (String)inlongGroupId, (String)inlongStreamId, (long)instanceProfile.getSinkDataTime(), (int)1, (long)1L, (long)this.auditVersion);
            } else {
                LOGGER.error("add instance to memory init failed instanceId {}", (Object)instance.getInstanceId());
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_ADD_INSTANCE_MEM_FAILED, (String)inlongGroupId, (String)inlongStreamId, (long)instanceProfile.getSinkDataTime(), (int)1, (long)1L, (long)this.auditVersion);
            }
        }
        catch (Throwable t) {
            LOGGER.error("add instance error.", t);
        }
    }

    private void stopAllInstances() {
        this.instanceMap.values().forEach(instance -> this.notifyDestroyInstance(instance.getInstanceId()));
        this.instanceMap.values().forEach(instance -> this.deleteFromMemory(instance.getInstanceId()));
        this.instanceMap.clear();
    }

    public boolean shouldAddAgain(String fileName, long lastModifyTime) {
        InstanceProfile profileFromStore = this.instanceStore.getInstance(this.taskId, fileName);
        if (profileFromStore == null) {
            LOGGER.debug("not in instance store should add {}", (Object)fileName);
            return true;
        }
        InstanceStateEnum state = profileFromStore.getState();
        if (state == InstanceStateEnum.FINISHED && lastModifyTime > profileFromStore.getModifyTime()) {
            LOGGER.debug("finished but file update again {}", (Object)fileName);
            return true;
        }
        if (state == InstanceStateEnum.DELETE) {
            LOGGER.debug("delete and add again {}", (Object)fileName);
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return (double)(this.actionQueue.size() + this.addActionQueue.size()) >= 80.0;
    }

    public long getFinishedInstanceCount() {
        int count = 0;
        List instances = this.instanceStore.getInstances(this.taskId);
        for (int i = 0; i < instances.size(); ++i) {
            if (((InstanceProfile)instances.get(i)).getState() != InstanceStateEnum.FINISHED) continue;
            ++count;
        }
        return count;
    }

    public int getInstanceNum() {
        return this.instanceMap.size();
    }

    private class InstancePrintStat {
        public int defaultCount = 0;
        public int finishedCount = 0;
        public int deleteCount = 0;
        public int otherCount = 0;

        private InstancePrintStat() {
        }

        private void stat(InstanceStateEnum state) {
            switch (state) {
                case DEFAULT: {
                    ++this.defaultCount;
                    break;
                }
                case FINISHED: {
                    ++this.finishedCount;
                    break;
                }
                case DELETE: {
                    ++this.deleteCount;
                }
                default: {
                    ++this.otherCount;
                }
            }
        }

        public String toString() {
            return String.format("default %d finished %d delete %d other %d", this.defaultCount, this.finishedCount, this.deleteCount, this.otherCount);
        }
    }
}

