/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.common.bounded.BoundaryType;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.pojo.schedule.airflow.AirflowConnection;
import org.apache.inlong.manager.pojo.schedule.airflow.DAG;
import org.apache.inlong.manager.pojo.schedule.airflow.DAGCollection;
import org.apache.inlong.manager.pojo.schedule.airflow.DAGRun;
import org.apache.inlong.manager.pojo.schedule.airflow.DAGRunConf;
import org.apache.inlong.manager.schedule.ScheduleEngine;
import org.apache.inlong.manager.schedule.ScheduleUnit;
import org.apache.inlong.manager.schedule.airflow.AirflowServerClient;
import org.apache.inlong.manager.schedule.airflow.api.AirflowResponse;
import org.apache.inlong.manager.schedule.airflow.api.connection.AirflowConnectionCreator;
import org.apache.inlong.manager.schedule.airflow.api.connection.AirflowConnectionGetter;
import org.apache.inlong.manager.schedule.airflow.api.dag.DAGCollectionUpdater;
import org.apache.inlong.manager.schedule.airflow.api.dag.DAGDeletor;
import org.apache.inlong.manager.schedule.airflow.api.dag.DAGUpdater;
import org.apache.inlong.manager.schedule.airflow.api.dagruns.DAGRunsTrigger;
import org.apache.inlong.manager.schedule.airflow.config.AirflowConfig;
import org.apache.inlong.manager.schedule.airflow.util.ConcurrentHashSet;
import org.apache.inlong.manager.schedule.airflow.util.DAGUtil;
import org.apache.inlong.manager.schedule.airflow.util.DateUtil;
import org.apache.inlong.manager.schedule.exception.AirflowScheduleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AirflowScheduleEngine
implements ScheduleEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AirflowScheduleEngine.class);
    private final Set<String> scheduledJobSet = new ConcurrentHashSet<String>();
    private AirflowServerClient serverClient;
    private AirflowConfig airflowConfig;

    public AirflowScheduleEngine(AirflowServerClient serverClient, AirflowConfig airflowConfig) {
        this.serverClient = serverClient;
        this.airflowConfig = airflowConfig;
        this.start();
    }

    @Override
    public void start() {
        try {
            this.initConnection();
            this.switchOriginalDAG(false);
            this.switchAllTaskDAG(false);
            LOGGER.info("Airflow initialization succeeded.");
        }
        catch (Exception e) {
            LOGGER.error("Airflow initialization failed.", (Throwable)e);
        }
    }

    private void initConnection() throws Exception {
        LOGGER.info("Initializing Inlong Manager AirflowConnection for Airflow ... ");
        AirflowResponse<AirflowConnection> response = this.serverClient.sendRequest(new AirflowConnectionGetter(this.airflowConfig.getConnectionId()));
        if (!response.isSuccess()) {
            AirflowConnection newConn = new AirflowConnection(this.airflowConfig.getConnectionId(), "HTTP", "", this.airflowConfig.getInlongManagerHost(), this.airflowConfig.getInlongUsername(), "/inlong/manager/api/group/submitOfflineJob", Integer.valueOf(this.airflowConfig.getInlongManagerPort()), this.airflowConfig.getInlongPassword(), "");
            response = this.serverClient.sendRequest(new AirflowConnectionCreator(newConn));
            LOGGER.info("AirflowConnection registration response: {}", (Object)response.toString());
            if (!response.isSuccess()) {
                LOGGER.error("Initialization connection failed.");
                throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.INIT_CONNECTION_FAILED, "Initialization connection failed.");
            }
        }
    }

    private void switchOriginalDAG(boolean isPaused) {
        for (String dagId : Arrays.asList(this.airflowConfig.getDagCleanerId(), this.airflowConfig.getDagCreatorId())) {
            try {
                AirflowResponse<DAG> response = this.serverClient.sendRequest(new DAGUpdater(dagId, isPaused));
                LOGGER.info("Response to {} the original DAG : {}", (Object)(isPaused ? "stop" : "start"), (Object)response.toString());
                if (response.isSuccess()) continue;
                throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.TASK_DAG_SWITCH_FAILED, String.format("%s does not exist or failed to %s.", dagId, isPaused ? "stop" : "start"));
            }
            catch (Exception e) {
                LOGGER.error("The original DAG {} failed.", (Object)(isPaused ? "stop" : "start"), (Object)e);
                throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.TASK_DAG_SWITCH_FAILED, String.format("The original DAG %s failed: %s.", isPaused ? "stop" : "start", e.getMessage()));
            }
        }
    }

    private void switchAllTaskDAG(boolean isPaused) {
        try {
            List dagList;
            AirflowResponse<DAGCollection> response = this.serverClient.sendRequest(new DAGCollectionUpdater("inlong_offline_task_", isPaused));
            LOGGER.info("Response to {} task DAG : {}", (Object)(isPaused ? "stop" : "start"), (Object)response.toString());
            if (!response.isSuccess()) {
                throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.TASK_DAG_SWITCH_FAILED, String.format("Failed to %s task DAGs.", isPaused ? "stop" : "start"));
            }
            if (!isPaused && (dagList = response.getData().getDags()) != null) {
                dagList.forEach(dag -> this.scheduledJobSet.add(dag.getDagId().substring("inlong_offline_task_".length() - 1)));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to {} task DAGs.", (Object)(isPaused ? "stop" : "start"), (Object)e);
            throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.TASK_DAG_SWITCH_FAILED, String.format("Failed to %s task DAGs: %s", isPaused ? "stop" : "start", e.getMessage()));
        }
    }

    @Override
    public boolean handleRegister(ScheduleInfo scheduleInfo) {
        try {
            LOGGER.info("Registering DAG for {}", (Object)scheduleInfo.getInlongGroupId());
            return this.doRegister(scheduleInfo, true);
        }
        catch (Exception e) {
            LOGGER.error("The Airflow scheduling task with Group ID {} failed to register.", (Object)scheduleInfo.getInlongGroupId(), (Object)e);
            throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.SCHEDULE_TASK_REGISTER_FAILED, String.format("The Airflow scheduling task with Group ID %s failed to register: %s", scheduleInfo.getInlongGroupId(), e.getMessage()));
        }
    }

    @Override
    public boolean handleUnregister(String groupId) {
        LOGGER.info("Unregistering Airflow Dag with GroupId {} ", (Object)groupId);
        if (this.scheduledJobSet.contains(groupId)) {
            try {
                if (!this.completelyDelete(DAGUtil.buildDAGIdByGroupId(groupId))) {
                    return false;
                }
            }
            catch (Exception e) {
                LOGGER.warn("May not be completely removed {}", (Object)groupId, (Object)e);
            }
        }
        this.scheduledJobSet.remove(groupId);
        LOGGER.info("Un-registered airflow schedule info for {}", (Object)groupId);
        return true;
    }

    private boolean completelyDelete(String groupId) throws Exception {
        DAGRunConf dagRunConf = DAGRunConf.builder().inlongGroupId(DAGUtil.buildDAGIdByGroupId(groupId)).build();
        AirflowResponse<DAGRun> response = this.serverClient.sendRequest(new DAGRunsTrigger(this.airflowConfig.getDagCleanerId(), (Map<String, Object>)ImmutableMap.of((Object)"conf", (Object)dagRunConf)));
        LOGGER.info("Response to DAG file clearing: {}", (Object)response.toString());
        if (!response.isSuccess()) {
            LOGGER.warn("Failed to delete DAG file corresponding to {}.", (Object)groupId);
            return false;
        }
        AirflowResponse<Object> deleteResponse = this.serverClient.sendRequest(new DAGDeletor(groupId));
        LOGGER.info("Response to DAG scheduling instance clearing: {}", (Object)deleteResponse.toString());
        if (!deleteResponse.isSuccess()) {
            LOGGER.warn("Failed to delete DAG instance corresponding to {}.", (Object)groupId);
        }
        return deleteResponse.isSuccess();
    }

    @Override
    public boolean handleUpdate(ScheduleInfo scheduleInfo) {
        try {
            LOGGER.info("Updating DAG for {}", (Object)scheduleInfo.getInlongGroupId());
            return this.doRegister(scheduleInfo, false);
        }
        catch (Exception e) {
            LOGGER.error("The Airflow scheduling task with Group ID {} failed to update.", (Object)scheduleInfo.getInlongGroupId(), (Object)e);
            throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.SCHEDULE_TASK_UPDATE_FAILED, String.format("The Airflow scheduling task with Group ID %s failed to update: %s", scheduleInfo.getInlongGroupId(), e.getMessage()));
        }
    }

    public boolean doRegister(ScheduleInfo scheduleInfo, boolean isFirst) throws Exception {
        if (isFirst && this.scheduledJobSet.contains(scheduleInfo.getInlongGroupId())) {
            throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.DAG_DUPLICATE, String.format("Group %s is already registered", scheduleInfo.getInlongGroupId()));
        }
        DAGRunConf.DAGRunConfBuilder confBuilder = DAGRunConf.builder().inlongGroupId(scheduleInfo.getInlongGroupId()).startTime(scheduleInfo.getStartTime().getTime()).endTime(scheduleInfo.getEndTime().getTime()).boundaryType(BoundaryType.TIME.getType()).connectionId(this.airflowConfig.getConnectionId()).timezone("Asia/Shanghai");
        confBuilder = scheduleInfo.getScheduleType() == 1 ? confBuilder.cronExpr(scheduleInfo.getCrontabExpression()) : confBuilder.secondsInterval(DateUtil.intervalToSeconds(scheduleInfo.getScheduleInterval().intValue(), scheduleInfo.getScheduleUnit())).startTime(ScheduleUnit.getScheduleUnit(scheduleInfo.getScheduleUnit()) == ScheduleUnit.ONE_ROUND ? scheduleInfo.getEndTime().getTime() : scheduleInfo.getStartTime().getTime());
        DAGRunConf dagRunConf = confBuilder.build();
        AirflowResponse<DAGRun> response = this.serverClient.sendRequest(new DAGRunsTrigger(this.airflowConfig.getDagCreatorId(), (Map<String, Object>)ImmutableMap.of((Object)"conf", (Object)dagRunConf)));
        LOGGER.info("DAG {} response: {}", (Object)(isFirst ? "registration" : "update"), (Object)response.toString());
        if (response.isSuccess()) {
            this.scheduledJobSet.add(scheduleInfo.getInlongGroupId());
        }
        return response.isSuccess();
    }

    @Override
    public void stop() {
        try {
            this.switchOriginalDAG(true);
            this.switchAllTaskDAG(true);
        }
        catch (Exception e) {
            LOGGER.error("Airflow Schedule Engine shutdown failed: ", (Throwable)e);
            throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.SCHEDULE_ENGINE_SHUTDOWN_FAILED, String.format("Airflow Schedule Engine shutdown failed: %s", e.getMessage()));
        }
    }
}

