/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

class OkHttpWebSocketImpl
implements io.fabric8.kubernetes.client.http.WebSocket {
    private WebSocket webSocket;
    private Runnable requestMethod;

    public OkHttpWebSocketImpl(WebSocket webSocket, Runnable requestMethod) {
        this.webSocket = webSocket;
        this.requestMethod = requestMethod;
    }

    public boolean send(ByteBuffer buffer) {
        return this.webSocket.send(ByteString.of((ByteBuffer)buffer));
    }

    public boolean sendClose(int code, String reason) {
        return this.webSocket.close(code, reason);
    }

    public long queueSize() {
        return this.webSocket.queueSize();
    }

    public void request() {
        this.requestMethod.run();
    }

    static class BuilderImpl
    implements WebSocket.Builder {
        private Request.Builder builder = new Request.Builder();
        private OkHttpClient httpClient;

        public BuilderImpl(OkHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public WebSocket.Builder uri(URI uri) {
            this.builder.url(uri.toString());
            return this;
        }

        public CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket> buildAsync(final WebSocket.Listener listener) {
            Request request = this.builder.build();
            final CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket> future = new CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket>();
            this.httpClient.newWebSocket(request, new WebSocketListener(){
                private volatile boolean opened;
                private boolean more = true;
                private ReentrantLock lock = new ReentrantLock();
                private Condition moreRequested = this.lock.newCondition();

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    if (response != null) {
                        response.close();
                    }
                    if (!this.opened) {
                        if (response != null) {
                            try {
                                future.completeExceptionally((Throwable)new WebSocketHandshakeException(new OkHttpClientImpl.OkHttpResponseImpl(response, null)).initCause(t));
                            }
                            catch (IOException iOException) {}
                        } else {
                            future.completeExceptionally(t);
                        }
                    } else {
                        listener.onError((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), t);
                    }
                }

                public void onOpen(WebSocket webSocket, Response response) {
                    this.opened = true;
                    if (response != null) {
                        response.close();
                    }
                    OkHttpWebSocketImpl value = new OkHttpWebSocketImpl(webSocket, this::request);
                    listener.onOpen((io.fabric8.kubernetes.client.http.WebSocket)value);
                    future.complete(value);
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    this.awaitMoreRequest();
                    listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), bytes.asByteBuffer());
                }

                public void onMessage(WebSocket webSocket, String text) {
                    this.awaitMoreRequest();
                    listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), text);
                }

                private void awaitMoreRequest() {
                    this.lock.lock();
                    try {
                        while (!this.more) {
                            this.moreRequested.await();
                        }
                        this.more = false;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw KubernetesClientException.launderThrowable((Throwable)e);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }

                private void request() {
                    this.lock.lock();
                    try {
                        this.more = true;
                        this.moreRequested.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    this.awaitMoreRequest();
                    listener.onClose((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), code, reason);
                }
            });
            return future;
        }

        public WebSocket.Builder header(String name, String value) {
            this.builder = this.builder.addHeader(name, value);
            return this;
        }

        public WebSocket.Builder setHeader(String k, String v) {
            this.builder = this.builder.header(k, v);
            return this;
        }

        public WebSocket.Builder subprotocol(String protocol) {
            this.builder.header("Sec-WebSocket-Protocol", protocol);
            return this;
        }
    }
}

