/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import org.apache.flume.sink.hdfs.HDFSCompressedDataStream;
import org.apache.flume.sink.hdfs.HDFSDataStream;
import org.apache.flume.sink.hdfs.HDFSSequenceFile;
import org.apache.flume.sink.hdfs.HDFSWriter;

public class HDFSWriterFactory {
    static final String SequenceFileType = "SequenceFile";
    static final String DataStreamType = "DataStream";
    static final String CompStreamType = "CompressedStream";

    public HDFSWriter getWriter(String fileType) throws IOException {
        if (fileType.equalsIgnoreCase(SequenceFileType)) {
            return new HDFSSequenceFile();
        }
        if (fileType.equalsIgnoreCase(DataStreamType)) {
            return new HDFSDataStream();
        }
        if (fileType.equalsIgnoreCase(CompStreamType)) {
            return new HDFSCompressedDataStream();
        }
        throw new IOException("File type " + fileType + " not supported");
    }
}

