/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset.offsetfile;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.inlong.tubemq.corebase.daemon.AbstractDaemonService;
import org.apache.inlong.tubemq.corebase.rv.RetValue;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetStorage;
import org.apache.inlong.tubemq.server.broker.offset.OffsetStorageInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetfile.GroupOffsetStgInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetfile.OffsetStgInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetfile.PartStgInfo;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOffsetStorage
extends AbstractDaemonService
implements OffsetStorage {
    private static final Logger logger = LoggerFactory.getLogger(FileOffsetStorage.class);
    private static final Gson GSON = new Gson();
    private static final String offsetSubDir = "offsetDir";
    private static final String OFFSET_FILENAME = "offsets";
    private static final String OFFSET_FILENAME_SUFFIX_FORMAL = ".meta";
    private static final String OFFSET_FILENAME_SUFFIX_TMP = ".tmp";
    private static final String OFFSET_FILENAME_SUFFIX_MID = ".mid";
    private static final String OFFSET_FILENAME_SUFFIX_OLD = ".old";
    private final int brokerId;
    private final String offsetsDirBase;
    private final String offsetsFileBase;
    private final long syncDurWarnMs;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicBoolean isUpdated = new AtomicBoolean(false);
    private GroupOffsetStgInfo groupOffsetInfo;
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> groupTopicsInfo = new ConcurrentHashMap();

    public FileOffsetStorage(int brokerId, String offsetFilePath, long syncIntMs, long syncDurWarnMs) {
        super("Offset-File", syncIntMs);
        this.brokerId = brokerId;
        this.syncDurWarnMs = syncDurWarnMs;
        this.offsetsDirBase = offsetFilePath + File.separator + offsetSubDir;
        this.offsetsFileBase = this.offsetsDirBase + File.separator + OFFSET_FILENAME;
    }

    public void start() {
        if (!this.isStarted.compareAndSet(false, true)) {
            return;
        }
        logger.info("[File offsets] initial File offsets starting...");
        super.start();
        if (!this.initialFileInfo()) {
            logger.error("[File offsets] initial File offsets failure!");
            System.exit(2);
            return;
        }
        this.isStarted.set(true);
        logger.info("[File offsets] initial File offsets started!");
    }

    protected void loopProcess(StringBuilder strBuff) {
        if (!this.isStarted.get()) {
            return;
        }
        if (!this.isUpdated.compareAndSet(true, false)) {
            return;
        }
        long curStartTime = System.currentTimeMillis();
        FileOffsetStorage.storeOffsetStgInfoToFile(this.groupOffsetInfo, this.offsetsFileBase);
        long wastMs = System.currentTimeMillis() - curStartTime;
        if (wastMs > this.syncDurWarnMs) {
            logger.warn("[File offsets] sync offsets to file over warn value, wast={}ms, warnMs={}", (Object)wastMs, (Object)this.syncDurWarnMs);
        }
    }

    @Override
    public void close() {
        if (!this.isStarted.compareAndSet(true, false)) {
            return;
        }
        super.stop();
        logger.info("[File offsets] begin sync content to file, begin");
        long curStartTime = System.currentTimeMillis();
        FileOffsetStorage.storeOffsetStgInfoToFile(this.groupOffsetInfo, this.offsetsFileBase);
        long wastMs = System.currentTimeMillis() - curStartTime;
        if (wastMs > this.syncDurWarnMs) {
            logger.warn("[File offsets] close and sync offsets to file, wast={}ms, warnMs={}", (Object)wastMs, (Object)this.syncDurWarnMs);
        }
    }

    @Override
    public ConcurrentHashMap<String, OffsetStorageInfo> loadGroupStgInfo(String group) {
        ConcurrentHashMap<String, OffsetStorageInfo> result = new ConcurrentHashMap<String, OffsetStorageInfo>();
        if (!this.isStarted.get()) {
            return result;
        }
        Map<String, PartStgInfo> partStgInfos = this.groupOffsetInfo.getOffsetStgInfos(group);
        if (partStgInfos == null) {
            return result;
        }
        for (Map.Entry<String, PartStgInfo> entry : partStgInfos.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            PartStgInfo partStgInfo = entry.getValue();
            result.put(entry.getKey(), new OffsetStorageInfo(partStgInfo.getTopic(), this.brokerId, partStgInfo.getPartId(), partStgInfo.getLstRstTerm(), partStgInfo.getLstOffset(), partStgInfo.getMsgId(), false, partStgInfo.getLstUpdTime()));
        }
        return result;
    }

    @Override
    public OffsetStorageInfo loadOffset(String group, String topic, int partitionId) {
        if (!this.isStarted.get()) {
            return null;
        }
        PartStgInfo partStgInfo = this.groupOffsetInfo.getOffsetStgInfo(group, topic, partitionId);
        if (partStgInfo == null) {
            return null;
        }
        return new OffsetStorageInfo(topic, this.brokerId, partitionId, partStgInfo.getLstRstTerm(), partStgInfo.getLstOffset(), partStgInfo.getMsgId(), false, partStgInfo.getLstUpdTime());
    }

    @Override
    public boolean commitOffset(String group, Collection<OffsetStorageInfo> offsetInfoList, boolean isFailRetry) {
        if (offsetInfoList == null || offsetInfoList.isEmpty()) {
            return false;
        }
        if (this.groupOffsetInfo.storeOffsetStgInfo(group, offsetInfoList, this.groupTopicsInfo)) {
            this.isUpdated.set(true);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Set<String>> queryGroupTopicInfo(Set<String> groups) {
        if (this.groupTopicsInfo.isEmpty()) {
            return Collections.emptyMap();
        }
        if (groups == null) {
            HashMap<String, Set<String>> groupTopicMap = new HashMap<String, Set<String>>();
            for (Map.Entry<String, ConcurrentHashSet<String>> entry : this.groupTopicsInfo.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                Set tmpTopics = groupTopicMap.computeIfAbsent(entry.getKey(), k -> new HashSet());
                tmpTopics.addAll((Collection)entry.getValue());
            }
            return groupTopicMap;
        }
        if (groups.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> groupTopicMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, ConcurrentHashSet<String>> entry : this.groupTopicsInfo.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty() || !groups.contains(entry.getKey())) continue;
            Set tmpTopics = groupTopicMap.computeIfAbsent(entry.getKey(), k -> new HashSet());
            tmpTopics.addAll((Collection)entry.getValue());
        }
        return groupTopicMap;
    }

    @Override
    public Map<Integer, Long> queryGroupOffsetInfo(String group, String topic, Set<Integer> partitionIds) {
        return this.groupOffsetInfo.queryGroupOffsetInfo(group, topic, partitionIds);
    }

    @Override
    public void deleteGroupOffsetInfo(Map<String, Map<String, Set<Integer>>> groupTopicPartMap) {
        if (groupTopicPartMap == null || groupTopicPartMap.isEmpty()) {
            return;
        }
        boolean isUpdated = false;
        HashSet<String> rmvTopics = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<Integer>>> entry : groupTopicPartMap.entrySet()) {
            ConcurrentHashSet<String> curTopics;
            if (entry == null || entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            if (this.groupOffsetInfo.rmvGroupOffsetInfo(entry.getKey(), entry.getValue())) {
                isUpdated = true;
            }
            if ((curTopics = this.groupTopicsInfo.get(entry.getKey())) == null) continue;
            for (String topic : curTopics) {
                if (topic == null || !this.groupOffsetInfo.includedTopic(entry.getKey(), topic)) continue;
                rmvTopics.add(topic);
            }
            if (rmvTopics.isEmpty()) continue;
            for (String topic : rmvTopics) {
                curTopics.remove((Object)topic);
            }
            if (!curTopics.isEmpty()) continue;
            this.groupTopicsInfo.remove(entry.getKey());
        }
        if (isUpdated) {
            this.isUpdated.set(true);
        }
    }

    @Override
    public Set<String> cleanExpiredGroupInfo(long checkTime, long expiredDurMs) {
        Set<String> rmvGroups = this.groupOffsetInfo.rmvExpiredGroupOffsetInfo(checkTime, expiredDurMs);
        if (!rmvGroups.isEmpty()) {
            for (String rmvGroup : rmvGroups) {
                this.groupTopicsInfo.remove(rmvGroup);
            }
            this.isUpdated.set(true);
        }
        return rmvGroups;
    }

    @Override
    public Set<String> cleanRmvTopicInfo(Set<String> rmvTopics) {
        HashSet<String> groups = new HashSet<String>();
        for (String topic : rmvTopics) {
            if (topic == null) continue;
            for (Map.Entry<String, ConcurrentHashSet<String>> entry : this.groupTopicsInfo.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty() || !entry.getValue().contains((Object)topic)) continue;
                groups.add(entry.getKey());
            }
        }
        if (groups.isEmpty()) {
            return groups;
        }
        for (String group : groups) {
            this.groupOffsetInfo.rmvGroupOffsetInfo(group, rmvTopics);
            ConcurrentHashSet<String> curTopics = this.groupTopicsInfo.get(group);
            if (curTopics == null) continue;
            curTopics.addAll(rmvTopics);
            if (!curTopics.isEmpty()) continue;
            this.groupTopicsInfo.remove(group);
        }
        this.isUpdated.set(true);
        return groups;
    }

    public String getOffsetsFileBase() {
        return this.offsetsFileBase;
    }

    public Map<String, OffsetHistoryInfo> getOffsetHistoryInfo(Set<String> groups) {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, OffsetHistoryInfo> result = new HashMap<String, OffsetHistoryInfo>();
        ConcurrentHashMap<String, OffsetStgInfo> offsetStgInfoMap = this.groupOffsetInfo.getGroupOffsetStgInfo();
        for (String group : groups) {
            OffsetStgInfo curStgInfo = offsetStgInfoMap.get(group);
            if (curStgInfo == null || curStgInfo.getPartOffsetInfo().isEmpty()) continue;
            OffsetHistoryInfo tmpHisInfo = new OffsetHistoryInfo(this.brokerId, group);
            ConcurrentHashMap<String, PartStgInfo> curPartStgInfoMap = curStgInfo.getPartOffsetInfo();
            for (PartStgInfo partStgInfo : curPartStgInfoMap.values()) {
                if (partStgInfo == null) continue;
                tmpHisInfo.addCsmOffsets(partStgInfo.getTopic(), partStgInfo.getPartId(), partStgInfo.getLstOffset(), 0L);
            }
            result.put(group, tmpHisInfo);
        }
        return result;
    }

    public boolean isFistUseFileStg() {
        File[] listFiles;
        boolean isFistUseFileStg = false;
        File baseDir = new File(this.offsetsDirBase);
        if (!baseDir.exists()) {
            if (!baseDir.mkdirs()) {
                logger.error("[File offsets] could not make File offset directory {}", (Object)baseDir.getAbsolutePath());
                System.exit(2);
            }
            isFistUseFileStg = true;
        }
        if (!baseDir.isDirectory() || !baseDir.canRead()) {
            logger.error("[File offsets] File offset path {} is not a readable directory", (Object)baseDir.getAbsolutePath());
            System.exit(2);
        }
        if ((listFiles = baseDir.listFiles()) != null) {
            isFistUseFileStg = true;
            for (File file : listFiles) {
                if (!file.isFile() || !file.getName().endsWith(OFFSET_FILENAME_SUFFIX_MID) && !file.getName().endsWith(OFFSET_FILENAME_SUFFIX_FORMAL) && !file.getName().endsWith(OFFSET_FILENAME_SUFFIX_OLD)) continue;
                isFistUseFileStg = false;
                break;
            }
        }
        return isFistUseFileStg;
    }

    private boolean initialFileInfo() {
        GroupOffsetStgInfo tmpOffsetInfoMap;
        if (!this.checkAndRecoverStgFiles()) {
            return false;
        }
        File dstFile = new File(this.offsetsFileBase + OFFSET_FILENAME_SUFFIX_FORMAL);
        if (dstFile.exists()) {
            String offsetsContent = FileOffsetStorage.getConfigFromFile(dstFile);
            if (offsetsContent == null) {
                logger.error("[File offsets] initial load storage file {} failure!", (Object)dstFile.getAbsoluteFile());
                return false;
            }
            try {
                tmpOffsetInfoMap = (GroupOffsetStgInfo)GSON.fromJson(offsetsContent, GroupOffsetStgInfo.class);
            }
            catch (Throwable ex) {
                logger.error("[File offsets] parse loaded json config failure", ex);
                return false;
            }
            if (tmpOffsetInfoMap == null) {
                logger.error("[File offsets] LOADED configure is null");
                return false;
            }
        } else {
            if (!this.isFistUseFileStg()) {
                logger.error("[File offsets] storage file {} is required!", (Object)dstFile.getAbsoluteFile());
                return false;
            }
            tmpOffsetInfoMap = new GroupOffsetStgInfo(this.brokerId);
            RetValue retValue = FileOffsetStorage.storeOffsetStgInfoToFile(tmpOffsetInfoMap, this.offsetsFileBase);
            if (!retValue.isSuccess()) {
                return false;
            }
        }
        this.groupOffsetInfo = tmpOffsetInfoMap;
        ConcurrentHashMap<String, OffsetStgInfo> offsetStgInfos = tmpOffsetInfoMap.getGroupOffsetStgInfo();
        if (offsetStgInfos == null || offsetStgInfos.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : offsetStgInfos.entrySet()) {
            ConcurrentHashMap<String, PartStgInfo> partStgInfoMap;
            if (entry == null || entry.getKey() == null || entry.getValue() == null || (partStgInfoMap = ((OffsetStgInfo)entry.getValue()).getPartOffsetInfo()) == null || partStgInfoMap.isEmpty()) continue;
            for (Map.Entry partEntry : partStgInfoMap.entrySet()) {
                if (partEntry == null || partEntry.getValue() == null) continue;
                ConcurrentHashSet<String> topicSet = this.groupTopicsInfo.get(entry.getKey());
                if (topicSet == null) {
                    ConcurrentHashSet<String> tmpSet = new ConcurrentHashSet();
                    topicSet = this.groupTopicsInfo.putIfAbsent((String)entry.getKey(), tmpSet);
                    if (topicSet == null) {
                        topicSet = tmpSet;
                    }
                }
                topicSet.add((Object)((PartStgInfo)partEntry.getValue()).getTopic());
            }
        }
        return true;
    }

    private boolean checkAndRecoverStgFiles() {
        File midFile = new File(this.offsetsFileBase + OFFSET_FILENAME_SUFFIX_MID);
        File dstFile = new File(this.offsetsFileBase + OFFSET_FILENAME_SUFFIX_FORMAL);
        File oldFile = new File(this.offsetsFileBase + OFFSET_FILENAME_SUFFIX_OLD);
        FileUtils.deleteQuietly((File)new File(this.offsetsFileBase + OFFSET_FILENAME_SUFFIX_TMP));
        try {
            if (midFile.exists()) {
                String fileContent = FileOffsetStorage.getConfigFromFile(midFile);
                if (fileContent == null) {
                    logger.error("[File offsets] load mid file {} failure!", (Object)midFile.getAbsoluteFile());
                    return false;
                }
                GroupOffsetStgInfo tmpGroupStgInfo = FileOffsetStorage.getOffsetStgInfoFromConfig(fileContent);
                if (tmpGroupStgInfo == null) {
                    logger.error("[File offsets] parse loaded mid file {} failure!", (Object)midFile.getAbsoluteFile());
                    return false;
                }
                tmpGroupStgInfo.clear();
                if (dstFile.exists() && !dstFile.delete()) {
                    logger.error("[File offsets] delete residual file1 {} failed!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                if (oldFile.exists() && !oldFile.delete()) {
                    logger.error("[File offsets] delete residual file2 {} failed!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                if (!FileOffsetStorage.storeConfigToFile(fileContent, oldFile)) {
                    logger.error("[File offsets] backup content to file {} failed!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                if (!oldFile.exists()) {
                    logger.error("[File offsets] backup file {} not found!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                FileUtils.moveFile((File)midFile, (File)dstFile);
                if (!dstFile.exists()) {
                    logger.error("[File offsets] moved formal file {} not found!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                if (!oldFile.delete()) {
                    logger.error("[File offsets] delete backup file {} failure!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                return true;
            }
            if (dstFile.exists()) {
                String fileContent = FileOffsetStorage.getConfigFromFile(dstFile);
                if (fileContent == null) {
                    logger.error("[File offsets] load formal file {} failure!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                GroupOffsetStgInfo tmpGroupStgInfo = FileOffsetStorage.getOffsetStgInfoFromConfig(fileContent);
                if (tmpGroupStgInfo == null) {
                    logger.error("[File offsets] parse loaded formal file {} failure!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                if (oldFile.exists() && !oldFile.delete()) {
                    logger.error("[File offsets] delete residual file {} failed!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                return true;
            }
            if (oldFile.exists()) {
                String fileContent = FileOffsetStorage.getConfigFromFile(oldFile);
                if (fileContent == null) {
                    logger.error("[File offsets] load backup file {} failure!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                GroupOffsetStgInfo tmpGroupStgInfo = FileOffsetStorage.getOffsetStgInfoFromConfig(fileContent);
                if (tmpGroupStgInfo == null) {
                    logger.error("[File offsets] parse loaded backup content {} failure!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
                tmpGroupStgInfo.clear();
                if (!FileOffsetStorage.storeConfigToFile(fileContent, dstFile)) {
                    logger.error("[File offsets] recover formal file {} failed!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                if (!dstFile.exists()) {
                    logger.error("[File offsets] recovered formal file {} not found!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                fileContent = FileOffsetStorage.getConfigFromFile(dstFile);
                if (fileContent == null) {
                    logger.error("[File offsets] load recovered file {} failure!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                tmpGroupStgInfo = FileOffsetStorage.getOffsetStgInfoFromConfig(fileContent);
                if (tmpGroupStgInfo == null) {
                    logger.error("[File offsets] parse recovered file content {} failure!", (Object)dstFile.getAbsoluteFile());
                    return false;
                }
                tmpGroupStgInfo.clear();
                if (!oldFile.delete()) {
                    logger.error("[File offsets] delete backup file {} failed!", (Object)oldFile.getAbsoluteFile());
                    return false;
                }
            }
            return true;
        }
        catch (Throwable ex) {
            if (ex instanceof IOException || ex instanceof SecurityException) {
                ServiceStatusHolder.addWriteIOErrCnt();
                BrokerSrvStatsHolder.incDiskIOExcCnt();
            }
            logger.error("[File offsets] recover offset storage files failed!", ex);
            return false;
        }
    }

    public RetValue backupGroupOffsets(String backupPath) {
        String fileNameBase = backupPath + File.separator + OFFSET_FILENAME;
        return FileOffsetStorage.storeOffsetStgInfoToFile(this.groupOffsetInfo, fileNameBase);
    }

    public static RetValue storeOffsetStgInfoToFile(GroupOffsetStgInfo offsetStgInfo, String fileNameBase) {
        String configStr;
        RetValue result = new RetValue();
        try {
            offsetStgInfo.setLstStoreTime();
            configStr = GSON.toJson((Object)offsetStgInfo, GroupOffsetStgInfo.class);
        }
        catch (Throwable ex) {
            logger.error("[File offsets] serial offset configure to json failure", ex);
            result.setFailResult("serial offset configure to json failure: " + ex.getMessage());
            return result;
        }
        File tmpFile = new File(fileNameBase + OFFSET_FILENAME_SUFFIX_TMP);
        if (!FileOffsetStorage.storeConfigToFile(configStr, tmpFile)) {
            logger.error("[File offsets] store json config to file {} failure", (Object)tmpFile.getAbsoluteFile());
            result.setFailResult("store json config failure to file: " + tmpFile.getAbsoluteFile());
            return result;
        }
        String readConfigStr = FileOffsetStorage.getConfigFromFile(tmpFile);
        if (!configStr.equals(readConfigStr)) {
            result.setFailResult("read stored offset json not equal!");
            return result;
        }
        File midFile = new File(fileNameBase + OFFSET_FILENAME_SUFFIX_MID);
        File dstFile = new File(fileNameBase + OFFSET_FILENAME_SUFFIX_FORMAL);
        File oldFile = new File(fileNameBase + OFFSET_FILENAME_SUFFIX_OLD);
        try {
            FileUtils.moveFile((File)tmpFile, (File)midFile);
            if (!midFile.exists()) {
                throw new Exception("Mid File " + midFile + " not found!");
            }
            if (dstFile.exists()) {
                FileUtils.moveFile((File)dstFile, (File)oldFile);
                if (!oldFile.exists()) {
                    throw new Exception("Backup File " + oldFile + " not found!");
                }
            }
            FileUtils.moveFile((File)midFile, (File)dstFile);
            if (!dstFile.exists()) {
                throw new Exception("Formal File " + dstFile + " not found!");
            }
            if (oldFile.exists() && !oldFile.delete()) {
                throw new Exception("Backup file " + oldFile + " delete failed!");
            }
            result.setSuccResult();
        }
        catch (Throwable ex) {
            if (ex instanceof IOException || ex instanceof SecurityException) {
                ServiceStatusHolder.addWriteIOErrCnt();
                BrokerSrvStatsHolder.incDiskIOExcCnt();
            }
            logger.error("[File offsets] exception thrown while adjust file name", ex);
            result.setFailResult("Exception while store to file: " + ex.getMessage());
        }
        return result;
    }

    public static GroupOffsetStgInfo getOffsetStgInfoFromConfig(String metaJsonStr) {
        try {
            return (GroupOffsetStgInfo)GSON.fromJson(metaJsonStr, GroupOffsetStgInfo.class);
        }
        catch (Throwable ex) {
            logger.error("[File offsets] parse offsets json failure, contents={}", (Object)metaJsonStr, (Object)ex);
            return null;
        }
    }

    public static boolean storeConfigToFile(String metaJsonStr, File tgtFile) {
        boolean isSuccess = false;
        try {
            FileUtils.writeStringToFile((File)tgtFile, (String)metaJsonStr, (Charset)StandardCharsets.UTF_8);
            isSuccess = true;
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                ServiceStatusHolder.addWriteIOErrCnt();
                BrokerSrvStatsHolder.incDiskIOExcCnt();
            }
            logger.error("[File offsets] exception thrown while writing to file {}", (Object)tgtFile.getAbsoluteFile(), (Object)ex);
        }
        return isSuccess;
    }

    public static String getConfigFromFile(File tgtFile) {
        try {
            return FileUtils.readFileToString((File)tgtFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                ServiceStatusHolder.addReadIOErrCnt();
                BrokerSrvStatsHolder.incDiskIOExcCnt();
            }
            logger.error("[File offsets] exception thrown while load from file {}", (Object)tgtFile.getAbsoluteFile(), (Object)ex);
            return null;
        }
    }
}

