/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.paramcheck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.metadata.MetadataManager;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeType;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBParameterUtils {
    private static final Logger logger = LoggerFactory.getLogger(PBParameterUtils.class);

    public static boolean checkProducerTopicList(List<String> reqTopicLst, StringBuilder strBuff, ProcessResult result) {
        if (reqTopicLst == null) {
            result.setFailResult(400, "Request miss necessary topic field info!");
            return result.isSuccess();
        }
        HashSet<String> transTopicList = new HashSet<String>();
        if (!reqTopicLst.isEmpty()) {
            for (String topic : reqTopicLst) {
                if (TStringUtils.isBlank((String)topic)) continue;
                if ((topic = topic.trim()).equals("__offset_history__")) {
                    result.setFailResult(400, strBuff.append("System Topic ").append("__offset_history__").append(" does not allow client produce data!").toString());
                    strBuff.delete(0, strBuff.length());
                    return result.isSuccess();
                }
                transTopicList.add(topic);
            }
        }
        if (transTopicList.size() > 1024) {
            result.setFailResult(400, strBuff.append("Booked topic's count over max value, required max count is ").append(1024).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(transTopicList);
        return result.isSuccess();
    }

    public static boolean checkConsumerTopicList(Set<String> depTopicSet, List<String> reqTopicLst, StringBuilder strBuff, ProcessResult result) {
        if (reqTopicLst == null || reqTopicLst.isEmpty()) {
            result.setFailResult(400, "Request miss necessary subscribed topicList data!");
            return result.isSuccess();
        }
        HashSet<String> transTopicSet = new HashSet<String>();
        for (String topicItem : reqTopicLst) {
            if (TStringUtils.isBlank((String)topicItem)) continue;
            transTopicSet.add(topicItem.trim());
        }
        if (transTopicSet.isEmpty()) {
            result.setFailResult(400, "Request subscribed topicList data must not Blank!");
            return result.isSuccess();
        }
        if (transTopicSet.size() > 1024) {
            result.setFailResult(400, strBuff.append("Subscribed topicList size over max value, required max count is ").append(1024).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        HashSet<String> invalidTopicSet = new HashSet<String>();
        for (String reqTopic : transTopicSet) {
            if (depTopicSet.contains(reqTopic)) continue;
            invalidTopicSet.add(reqTopic);
        }
        if (!invalidTopicSet.isEmpty()) {
            result.setFailResult(431, strBuff.append("Requested topic [").append(invalidTopicSet).append("] not deployed!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(transTopicSet);
        return result.isSuccess();
    }

    public static boolean checkConsumerOffsetSetInfo(ConsumeType csmType, Set<String> reqTopicSet, String requiredParts, StringBuilder strBuff, ProcessResult result) {
        String[] partOffsetItems;
        HashMap<String, Long> requiredPartMap = new HashMap<String, Long>();
        if (csmType != ConsumeType.CONSUME_BAND) {
            result.setSuccResult(requiredPartMap);
            return result.isSuccess();
        }
        if (TStringUtils.isBlank((String)requiredParts)) {
            result.setSuccResult(requiredPartMap);
            return result.isSuccess();
        }
        for (String partOffset : partOffsetItems = requiredParts.trim().split(",")) {
            String[] partKeyVal = partOffset.split("=");
            if (partKeyVal.length == 1) {
                result.setFailResult(400, strBuff.append("[Parameter error] unformatted Partition-Offset value : ").append(partOffset).append(" must be aa:bbb:ccc=val1,ddd:eee:ff=val2").toString());
                return result.isSuccess();
            }
            String[] partKeyItems = partKeyVal[0].trim().split(":");
            if (partKeyItems.length != 3) {
                result.setFailResult(400, strBuff.append("[Parameter error] unformatted Partition-Offset value : ").append(partOffset).append(" must be aa:bbb:ccc=val1,ddd:eee:ff=val2").toString());
                return result.isSuccess();
            }
            if (!reqTopicSet.contains(partKeyItems[1].trim())) {
                result.setFailResult(400, strBuff.append("[Parameter error] wrong offset reset for unsubscribed topic: reset item is ").append(partOffset).append(", request topicList are ").append(reqTopicSet).toString());
                return result.isSuccess();
            }
            try {
                requiredPartMap.put(partKeyVal[0].trim(), Long.parseLong(partKeyVal[1].trim()));
            }
            catch (Throwable ex) {
                result.setFailResult(400, strBuff.append("[Parameter error] required long type value of ").append(partOffset).append("' Offset!").toString());
                return result.isSuccess();
            }
        }
        result.setSuccResult(requiredPartMap);
        return result.isSuccess();
    }

    public static boolean checkConsumerInputInfo(ConsumerInfo inConsumerInfo, MasterConfig masterConfig, MetaDataService defMetaDataService, BrokerRunManager brokerRunManager, StringBuilder strBuff, ProcessResult result) throws Exception {
        if (!inConsumerInfo.isRequireBound()) {
            result.setSuccResult((Object)inConsumerInfo);
            return result.isSuccess();
        }
        if (TStringUtils.isBlank((String)inConsumerInfo.getSessionKey())) {
            result.setFailResult(400, "[Parameter error] blank value of sessionKey!");
            return result.isSuccess();
        }
        inConsumerInfo.setSessionKey(inConsumerInfo.getSessionKey().trim());
        if (inConsumerInfo.getSourceCount() <= 0) {
            result.setFailResult(400, "[Parameter error] totalSourceCount must over zero!");
            return result.isSuccess();
        }
        GroupResCtrlEntity offsetResetGroupEntity = defMetaDataService.getGroupCtrlConf(inConsumerInfo.getGroupName());
        if (masterConfig.isStartOffsetResetCheck() && offsetResetGroupEntity == null) {
            result.setFailResult(400, strBuff.append("[unauthorized subscribe] ConsumeGroup must be ").append("authorized by administrator before using bound subscribe").append(", please contact to administrator!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        int allowRate = offsetResetGroupEntity != null && offsetResetGroupEntity.getAllowedBrokerClientRate() > 0 ? offsetResetGroupEntity.getAllowedBrokerClientRate() : masterConfig.getMaxGroupBrokerConsumeRate();
        int maxBrokerCount = brokerRunManager.getSubTopicMaxBrokerCount(inConsumerInfo.getTopicSet());
        int curBClientRate = (int)Math.floor(maxBrokerCount / inConsumerInfo.getSourceCount());
        if (curBClientRate > allowRate) {
            int minClientCnt = maxBrokerCount / allowRate;
            if (maxBrokerCount % allowRate != 0) {
                ++minClientCnt;
            }
            result.setFailResult(400, strBuff.append("[Parameter error] System requires at least ").append(minClientCnt).append(" clients to consume data together, ").append("please add client resources!").toString());
            return result.isSuccess();
        }
        result.setSuccResult((Object)inConsumerInfo);
        return result.isSuccess();
    }

    public static boolean checkBrokerId(String brokerId, StringBuilder strBuff, ProcessResult result) {
        if (TStringUtils.isBlank((String)brokerId)) {
            result.setFailResult(400, "Request miss necessary brokerId data");
            return result.isSuccess();
        }
        String tmpValue = brokerId.trim();
        try {
            result.setSuccResult((Object)Integer.parseInt(tmpValue));
        }
        catch (Throwable e) {
            result.setFailResult(400, strBuff.append("Parse brokerId to int failure ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    public static boolean checkClientId(String clientId, StringBuilder strBuff, ProcessResult result) {
        return PBParameterUtils.getStringParameter(WebFieldDef.CLIENTID, clientId, strBuff, result);
    }

    public static boolean checkHostName(String hostName, StringBuilder strBuff, ProcessResult result) {
        return PBParameterUtils.getStringParameter(WebFieldDef.HOSTNAME, hostName, strBuff, result);
    }

    public static boolean checkGroupName(String groupName, StringBuilder strBuff, ProcessResult result) {
        return PBParameterUtils.getStringParameter(WebFieldDef.GROUPNAME, groupName, strBuff, result);
    }

    public static boolean getStringParameter(WebFieldDef fieldDef, String paramValue, StringBuilder strBuffer, ProcessResult result) {
        if (TStringUtils.isBlank((String)paramValue)) {
            result.setFailResult(strBuffer.append("Request miss necessary ").append(fieldDef.name).append(" data!").toString());
            strBuffer.delete(0, strBuffer.length());
            return result.isSuccess();
        }
        String tmpValue = paramValue.trim();
        if (tmpValue.length() > fieldDef.valMaxLen) {
            result.setFailResult(strBuffer.append(fieldDef.name).append("'s length over max value, allowed max length is ").append(fieldDef.valMaxLen).toString());
            strBuffer.delete(0, strBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult((Object)tmpValue);
        return result.isSuccess();
    }

    public static boolean getTopicNameParameter(String topicName, MetadataManager metadataManager, StringBuilder strBuffer, ProcessResult result) {
        if (!PBParameterUtils.getStringParameter(WebFieldDef.TOPICNAME, topicName, strBuffer, result)) {
            return result.isSuccess();
        }
        String tmpValue = (String)result.getRetData();
        if (metadataManager.getTopicMetadata(tmpValue) == null) {
            result.setFailResult(403, strBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(tmpValue).append(" not existed, please check your configure").toString());
            strBuffer.delete(0, strBuffer.length());
        }
        return result.isSuccess();
    }

    public static boolean getTopicNamePartIdInfo(boolean isProduce, String topicName, int partitionId, MetadataManager metadataManager, StringBuilder strBuffer, ProcessResult result) {
        int realPartition;
        if (!PBParameterUtils.getStringParameter(WebFieldDef.TOPICNAME, topicName, strBuffer, result)) {
            return result.isSuccess();
        }
        String tgtTopicName = (String)result.getRetData();
        if (isProduce && tgtTopicName.equals("__offset_history__")) {
            result.setFailResult(403, strBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(tgtTopicName).append(" does not allow producers to send data!").toString());
            strBuffer.delete(0, strBuffer.length());
            return result.isSuccess();
        }
        TopicMetadata topicMetadata = metadataManager.getTopicMetadata(tgtTopicName);
        if (topicMetadata == null) {
            result.setFailResult(403, strBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(tgtTopicName).append(" not existed, please check your configure").toString());
            strBuffer.delete(0, strBuffer.length());
            return result.isSuccess();
        }
        if (metadataManager.isClosedTopic(tgtTopicName)) {
            result.setFailResult(403, strBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(tgtTopicName).append(" has been closed").toString());
            strBuffer.delete(0, strBuffer.length());
            return result.isSuccess();
        }
        int n = realPartition = partitionId < 10000 ? partitionId : partitionId % 10000;
        if (realPartition < 0 || realPartition >= topicMetadata.getNumPartitions()) {
            result.setFailResult(403, strBuffer.append(WebFieldDef.PARTITIONID.name).append(" ").append(tgtTopicName).append("-").append(partitionId).append(" not existed, please check your configure").toString());
            strBuffer.delete(0, strBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult((Object)topicMetadata);
        return result.isSuccess();
    }
}

