/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.server.common.fileconfig.ZKConfig;
import org.apache.inlong.tubemq.server.common.zookeeper.Abortable;
import org.apache.inlong.tubemq.server.common.zookeeper.RecoverableZooKeeper;
import org.apache.inlong.tubemq.server.common.zookeeper.ZKUtil;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperConnectionException;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperWatcher
implements Watcher,
Abortable {
    public static final ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
        {
            this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperWatcher.class);
    protected final ZKConfig conf;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    private final Exception constructorCaller;
    private Abortable abortable;
    private CountDownLatch saslLatch = new CountDownLatch(1);
    private String baseZNode;
    private String quorum;
    private RecoverableZooKeeper recoverableZooKeeper;
    private String masterAddressZNode;

    public ZooKeeperWatcher(ZKConfig conf) throws ZooKeeperConnectionException, IOException {
        this(conf, null, false);
    }

    public ZooKeeperWatcher(ZKConfig conf, Abortable abortable) throws ZooKeeperConnectionException, IOException {
        this(conf, abortable, false);
    }

    public ZooKeeperWatcher(ZKConfig conf, Abortable abortable, boolean canCreateBaseZNode) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        try {
            throw new Exception("ZKW CONSTRUCTOR STACK TRACE FOR DEBUGGING");
        }
        catch (Exception e) {
            this.constructorCaller = e;
            this.quorum = conf.getZkServerAddr();
            this.abortable = abortable;
            this.setNodeNames(conf);
            this.recoverableZooKeeper = ZKUtil.connect(conf, this);
            if (canCreateBaseZNode) {
                this.createBaseZNodes();
            }
            return;
        }
    }

    private void createBaseZNodes() throws ZooKeeperConnectionException {
        try {
            ZKUtil.createAndFailSilent(this, this.baseZNode);
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), (Exception)((Object)e));
        }
    }

    public String toString() {
        return this.recoverableZooKeeper == null ? "" : Long.toHexString(this.recoverableZooKeeper.getSessionId());
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    private void setNodeNames(ZKConfig conf) {
        this.baseZNode = conf.getZkNodeRoot();
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, "master");
    }

    public String getBaseZNode() {
        return this.baseZNode;
    }

    public void saslLatchAwait() throws InterruptedException {
        this.saslLatch.await();
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public RecoverableZooKeeper getRecoverableZooKeeper() {
        return this.recoverableZooKeeper;
    }

    public void reconnectAfterExpiration() throws IOException, InterruptedException {
        this.recoverableZooKeeper.reconnectAfterExpiration();
    }

    public String getQuorum() {
        return this.quorum;
    }

    public void unregisterListener(ZooKeeperListener listener) {
        int i = 0;
        boolean exists = false;
        for (ZooKeeperListener listenerOfList : this.listeners) {
            if (listenerOfList.equals(listener)) {
                exists = true;
                break;
            }
            ++i;
        }
        if (exists) {
            this.listeners.remove(i);
        }
    }

    public void process(WatchedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.prefix("Received ZooKeeper Event, type=" + event.getType() + ", state=" + event.getState() + ", path=" + event.getPath()));
        }
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
        }
    }

    protected void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                long finished = System.currentTimeMillis() + (long)this.conf.getZkSyncTimeMs();
                while (System.currentTimeMillis() < finished) {
                    ThreadUtils.sleep((long)1L);
                    if (this.recoverableZooKeeper == null) continue;
                }
                if (this.recoverableZooKeeper == null) {
                    logger.error("ZK is null on connection event -- see stack trace for the stack trace when constructor was called on this zkw", (Throwable)this.constructorCaller);
                    throw new NullPointerException("ZK is null");
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug(Long.toHexString(this.recoverableZooKeeper.getSessionId()) + " connected");
                break;
            }
            case SaslAuthenticated: {
                if (!ZKUtil.isSecureZooKeeper()) break;
                this.saslLatch.countDown();
                break;
            }
            case AuthFailed: {
                if (!ZKUtil.isSecureZooKeeper()) break;
                this.saslLatch.countDown();
                break;
            }
            case Disconnected: {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                }
                this.recoverableZooKeeper.ensureConnectivity(null);
                break;
            }
            case Expired: {
                if (ZKUtil.isSecureZooKeeper()) {
                    this.saslLatch.countDown();
                }
                String msg = this.prefix(Long.toHexString(this.recoverableZooKeeper.getSessionId()) + " received expired from ZooKeeper, aborting");
                if (this.abortable != null) {
                    this.abortable.abort(msg, (Throwable)new KeeperException.SessionExpiredException());
                }
                this.recoverableZooKeeper.ensureConnectivity(null);
            }
        }
    }

    public void sync(String path) {
        this.recoverableZooKeeper.sync(path, null, null);
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        logger.error(this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.prefix("Received InterruptedException, doing nothing here"), (Throwable)ie);
        }
        Thread.currentThread().interrupt();
    }

    public void close() {
        try {
            if (this.recoverableZooKeeper != null) {
                this.recoverableZooKeeper.close();
                this.recoverableZooKeeper = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ZKConfig getZKConfig() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        this.abortable.abort(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.abortable.isAborted();
    }

    public String getMasterAddressZNode() {
        return this.masterAddressZNode;
    }
}

