/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.common.zookeeper.ZKUtil;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperWatcher;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsClusterConfigMapperImpl;
import org.apache.zookeeper.KeeperException;

public class ZKClusterConfigMapperImpl
extends AbsClusterConfigMapperImpl {
    private final ZooKeeperWatcher zkWatcher;
    private final String clrConfigRootDir;

    public ZKClusterConfigMapperImpl(String metaNodePrefix, ZooKeeperWatcher zkWatcher, StringBuilder strBuff) {
        this.zkWatcher = zkWatcher;
        this.clrConfigRootDir = strBuff.append(metaNodePrefix).append("/").append("clusterConfig").toString();
        strBuff.delete(0, strBuff.length());
    }

    @Override
    public void close() {
        this.clearCachedData();
        logger.info("[ZK Impl] close cluster configure finished!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        logger.info("[ZK Impl] load cluster configure start...");
        this.clearCachedData();
        List<String> childNodes = ZKUtil.getChildren(this.zkWatcher, this.clrConfigRootDir);
        if (childNodes == null) {
            logger.info("[ZK Impl] Not found cluster configure from ZooKeeper");
            return;
        }
        Gson gson = new Gson();
        Type type = new TypeToken<ClusterSettingEntity>(){}.getType();
        for (String itemKey : childNodes) {
            String clrConfigureStr;
            if (TStringUtils.isEmpty((String)itemKey) || !itemKey.equalsIgnoreCase("default_cluster_config")) continue;
            try {
                clrConfigureStr = ZKUtil.readDataMaybeNull(this.zkWatcher, strBuff.append(this.clrConfigRootDir).append("/").append(itemKey).toString());
                strBuff.delete(0, strBuff.length());
            }
            catch (KeeperException e) {
                BrokerSrvStatsHolder.incZKExcCnt();
                logger.error("KeeperException during load cluster configure from ZooKeeper", (Throwable)e);
                throw new LoadMetaException(e.getMessage());
            }
            if (clrConfigureStr == null) continue;
            this.putRecord2Caches((ClusterSettingEntity)gson.fromJson(clrConfigureStr, type));
            ++totalCnt;
        }
        logger.info(strBuff.append("[ZK Impl] loaded ").append(totalCnt).append(" cluster configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(ClusterSettingEntity entity, StringBuilder strBuff, ProcessResult result) {
        String entityStr = entity.toString();
        try {
            ZKUtil.updatePersistentPath(this.zkWatcher, strBuff.append(this.clrConfigRootDir).append("/").append(entity.getRecordKey()).toString(), entityStr);
            strBuff.delete(0, strBuff.length());
        }
        catch (Throwable t) {
            BrokerSrvStatsHolder.incZKExcCnt();
            strBuff.delete(0, strBuff.length());
            logger.error("[ZK Impl] put cluster configure failure ", t);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put cluster configure failure: ").append(t.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(StringBuilder strBuff, String key) {
        ZKUtil.delZNode(this.zkWatcher, strBuff.append(this.clrConfigRootDir).append("/").append(key).toString());
        strBuff.delete(0, strBuff.length());
        return true;
    }
}

