/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.corebase.utils.Tuple4;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.statusdef.StepStatus;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerSyncData;
import org.apache.inlong.tubemq.server.master.utils.BrokerStatusSamplePrint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRunStatusInfo {
    private static final Logger logger = LoggerFactory.getLogger(BrokerRunStatusInfo.class);
    private static final BrokerStatusSamplePrint statusFsmSamplePrint = new BrokerStatusSamplePrint(logger);
    private final BrokerRunManager brokerRunManager;
    private BrokerInfo brokerInfo;
    private String createId;
    private final AtomicBoolean isConfChanged = new AtomicBoolean(false);
    private final AtomicLong confChangeNo = new AtomicLong(-2L);
    private StepStatus curStepStatus;
    private volatile long nextStepOpTimeInMills = 0L;
    private final AtomicLong confLoadedNo = new AtomicLong(-2L);
    BrokerSyncData brokerSyncData = new BrokerSyncData();
    private boolean isOnline = false;
    private boolean isDoneDataLoad = false;
    private boolean isDoneDataSub = false;
    private boolean isDoneDataPub = false;
    private boolean isOverTLS = false;
    private long lastBrokerSyncTime = 0L;
    private long maxConfLoadedTimeInMs = 0L;
    private long curConfLoadTimeInMs = 0L;

    public BrokerRunStatusInfo(BrokerRunManager brokerRunManager, BrokerInfo brokerInfo, ManageStatus mngStatus, String brokerConfInfo, Map<String, String> topicConfInfoMap, boolean isOverTls) {
        this.brokerRunManager = brokerRunManager;
        this.reInitRunStatusInfo(brokerInfo, mngStatus, brokerConfInfo, topicConfInfoMap, isOverTls);
    }

    public void reInitRunStatusInfo(BrokerInfo brokerInfo, ManageStatus mngStatus, String brokerConfInfo, Map<String, String> topicConfInfoMap, boolean isOverTls) {
        this.resetStatusInfo();
        this.createId = String.valueOf(System.nanoTime());
        this.brokerInfo = brokerInfo;
        long curTime = System.currentTimeMillis();
        this.isOverTLS = isOverTls;
        this.isConfChanged.set(true);
        this.confChangeNo.set(curTime);
        this.brokerSyncData.updBrokerSyncData(true, this.confChangeNo.get(), mngStatus, brokerConfInfo, topicConfInfoMap);
        this.curStepStatus = StepStatus.STEP_STATUS_WAIT_ONLINE;
        this.nextStepOpTimeInMills = curTime + this.curStepStatus.getNormalDelayDurInMs();
    }

    public void notifyDataChanged() {
        this.isConfChanged.set(true);
        this.confChangeNo.incrementAndGet();
    }

    public Tuple2<Boolean, Boolean> getDataSyncStatus() {
        return new Tuple2((Object)this.isConfChanged.get(), (Object)(this.confChangeNo.get() == this.confLoadedNo.get() ? 1 : 0));
    }

    private boolean isDataChanged() {
        return this.isConfChanged.get() || this.curStepStatus == StepStatus.STEP_STATUS_UNDEFINED && this.confChangeNo.get() != this.confLoadedNo.get();
    }

    public String getCreateId() {
        return this.createId;
    }

    public boolean isOverTLS() {
        return this.isOverTLS;
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public boolean inProcessingStatus() {
        return this.curStepStatus != StepStatus.STEP_STATUS_UNDEFINED;
    }

    public StepStatus getCurStepStatus() {
        return this.curStepStatus;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public Tuple4<Long, Integer, String, List<String>> getNeedSyncData() {
        return this.brokerSyncData.getBrokerSyncData();
    }

    public void bookBrokerReportInfo(boolean isRegister, boolean isOnline, long repConfigId, int repCheckSumId, boolean isTackData, String repBrokerConfInfo, List<String> repTopicConfs, StringBuilder sBuffer) {
        this.isOnline = isOnline;
        boolean isSynchronized = this.brokerSyncData.bookBrokerReportInfo(this.brokerInfo, repConfigId, repCheckSumId, isTackData, repBrokerConfInfo, repTopicConfs);
        if (isRegister && isOnline && isTackData) {
            Tuple2<ManageStatus, Map<String, TopicInfo>> syncData = this.brokerSyncData.getBrokerPublishInfo();
            this.brokerRunManager.iniBrokerConfInfo(this.brokerInfo.getBrokerId(), (ManageStatus)((Object)syncData.getF0()), (Map)syncData.getF1());
        }
        this.goNextStatus(isRegister, isSynchronized, sBuffer);
    }

    public StringBuilder toJsonString(StringBuilder sBuffer) {
        Tuple2<Boolean, Boolean> confStatusTuple = this.getDataSyncStatus();
        sBuffer.append("\"BrokerRunStatusInfo\":{\"type\":\"BrokerRunStatusInfo\"").append(",\"brokerInfo\":\"").append(this.brokerInfo.getBrokerStrInfo()).append("\",\"createId\":\"").append(this.createId).append("\",\"isConfChanged\":").append(confStatusTuple.getF0()).append(",\"isConfLoaded\":").append(confStatusTuple.getF1()).append(",\"confChangeNo\":").append(this.confChangeNo.get()).append(",\"curStepStatus\":\"").append(this.curStepStatus.getDescription()).append("\",\"nextStepOpTimeInMills\":").append(this.nextStepOpTimeInMills).append(",\"confLoadedNo\":").append(this.confLoadedNo.get()).append(",\"isOnline\":").append(this.isOnline).append(",\"isDoneDataLoad\":").append(this.isDoneDataLoad).append(",\"isDoneDataSub\":").append(this.isDoneDataSub).append(",\"isDoneDataPub\":").append(this.isDoneDataPub).append(",\"isOverTLS\":").append(this.isOverTLS).append(",\"lastBrokerSyncTime\":").append(this.lastBrokerSyncTime).append(",\"maxConfLoadedTimeInMs\":").append(this.maxConfLoadedTimeInMs).append(",\"curConfLoadTimeInMs\":").append(this.curConfLoadTimeInMs).append(",\"BrokerSyncData\":");
        this.brokerSyncData.toJsonString(sBuffer);
        sBuffer.append("}");
        return sBuffer;
    }

    private void goNextStatus(boolean isRegister, boolean isSynchronized, StringBuilder sBuffer) {
        if (isRegister) {
            this.goRegNextStatus(isSynchronized);
        } else {
            this.goNonRegNextStatus(isSynchronized);
        }
        this.execEvent(sBuffer);
    }

    private void execEvent(StringBuilder sBuffer) {
        switch (this.curStepStatus) {
            case STEP_STATUS_LOAD_DATA: {
                this.loadNewMetaData(sBuffer);
                break;
            }
            case STEP_STATUS_WAIT_SUBSCRIBE: {
                if (!this.execSyncDataToSub()) break;
                this.execSyncDataToPub();
                this.curStepStatus = StepStatus.STEP_STATUS_WAIT_PUBLISH;
                this.nextStepOpTimeInMills = System.currentTimeMillis() + this.curStepStatus.getShortDelayDurIdnMs();
                break;
            }
            case STEP_STATUS_WAIT_PUBLISH: {
                this.execSyncDataToPub();
                break;
            }
        }
    }

    private void goRegNextStatus(boolean isSynchronized) {
        this.resetStatusInfo();
        this.curStepStatus = this.isOnline ? (isSynchronized ? StepStatus.STEP_STATUS_WAIT_SUBSCRIBE : StepStatus.STEP_STATUS_WAIT_SYNC) : StepStatus.STEP_STATUS_WAIT_ONLINE;
    }

    private void goNonRegNextStatus(boolean isSynchronized) {
        switch (this.curStepStatus) {
            case STEP_STATUS_UNDEFINED: {
                if (isSynchronized && !this.isDataChanged() && !this.needForceSyncData()) break;
                this.resetStatusInfo();
                this.curStepStatus = StepStatus.STEP_STATUS_LOAD_DATA;
                this.nextStepOpTimeInMills = System.currentTimeMillis() + this.curStepStatus.getNormalDelayDurInMs();
                break;
            }
            case STEP_STATUS_LOAD_DATA: {
                if (!this.isDoneDataLoad || !this.isOnline) break;
                this.curStepStatus = isSynchronized ? StepStatus.STEP_STATUS_WAIT_SUBSCRIBE : StepStatus.STEP_STATUS_WAIT_SYNC;
                this.nextStepOpTimeInMills = System.currentTimeMillis() + this.curStepStatus.getNormalDelayDurInMs();
                break;
            }
            case STEP_STATUS_WAIT_ONLINE: {
                if (!this.isOnline) break;
                this.curStepStatus = isSynchronized ? StepStatus.STEP_STATUS_WAIT_SUBSCRIBE : StepStatus.STEP_STATUS_WAIT_SYNC;
                this.nextStepOpTimeInMills = System.currentTimeMillis() + this.curStepStatus.getNormalDelayDurInMs();
                break;
            }
            case STEP_STATUS_WAIT_SYNC: {
                if (!isSynchronized) break;
                this.curStepStatus = StepStatus.STEP_STATUS_WAIT_SUBSCRIBE;
                this.nextStepOpTimeInMills = System.currentTimeMillis() + this.curStepStatus.getNormalDelayDurInMs();
                break;
            }
            case STEP_STATUS_WAIT_SUBSCRIBE: {
                if (!this.isDoneDataSub || System.currentTimeMillis() <= this.nextStepOpTimeInMills) break;
                this.curStepStatus = StepStatus.STEP_STATUS_WAIT_PUBLISH;
                this.nextStepOpTimeInMills = System.currentTimeMillis() + this.curStepStatus.getNormalDelayDurInMs();
                break;
            }
            default: {
                if (!this.isDoneDataPub || System.currentTimeMillis() <= this.nextStepOpTimeInMills) break;
                this.finishedDataSync();
            }
        }
    }

    private void loadNewMetaData(StringBuilder sBuffer) {
        if (this.isDoneDataLoad) {
            return;
        }
        boolean needForceSync = this.needForceSyncData();
        Tuple3<ManageStatus, String, Map<String, String>> curConfTuple = this.brokerRunManager.getBrokerMetaConfigInfo(this.brokerInfo.getBrokerId());
        if (TStringUtils.isBlank((String)((String)curConfTuple.getF1()))) {
            statusFsmSamplePrint.printWarn(sBuffer.append("[Broker Sync] found broker(").append(this.brokerInfo.getBrokerId()).append(") configure is null").toString());
            sBuffer.delete(0, sBuffer.length());
            return;
        }
        Tuple2<Boolean, Boolean> updResult = this.brokerSyncData.updBrokerSyncData(needForceSync, this.confChangeNo.get(), (ManageStatus)((Object)curConfTuple.getF0()), (String)curConfTuple.getF1(), (Map)curConfTuple.getF2());
        if (updResult == null) {
            return;
        }
        this.isDoneDataLoad = true;
        this.lastBrokerSyncTime = System.currentTimeMillis();
        if (!((Boolean)updResult.getF0()).booleanValue() && !((Boolean)updResult.getF1()).booleanValue()) {
            this.finishedDataSync();
        }
    }

    private boolean execSyncDataToSub() {
        if (this.isDoneDataSub) {
            return System.currentTimeMillis() > this.nextStepOpTimeInMills;
        }
        Tuple2<ManageStatus, Map<String, TopicInfo>> syncData = this.brokerSyncData.getBrokerPublishInfo();
        boolean needFastSync = this.brokerRunManager.updBrokerCsmConfInfo(this.brokerInfo.getBrokerId(), (ManageStatus)((Object)syncData.getF0()), (Map)syncData.getF1());
        this.isDoneDataSub = true;
        return needFastSync;
    }

    private void execSyncDataToPub() {
        if (this.isDoneDataPub) {
            return;
        }
        Tuple2<ManageStatus, Map<String, TopicInfo>> syncData = this.brokerSyncData.getBrokerPublishInfo();
        this.brokerRunManager.updBrokerPrdConfInfo(this.brokerInfo.getBrokerId(), (ManageStatus)((Object)syncData.getF0()), (Map)syncData.getF1());
        this.isDoneDataPub = true;
    }

    private void finishedDataSync() {
        this.confLoadedNo.set(this.brokerSyncData.getDataPushId());
        if (this.confLoadedNo.get() == this.confChangeNo.get()) {
            this.isConfChanged.set(false);
        }
        this.curStepStatus = StepStatus.STEP_STATUS_UNDEFINED;
        this.nextStepOpTimeInMills = 0L;
        long tmpDuration = System.currentTimeMillis() - this.curConfLoadTimeInMs;
        if (this.maxConfLoadedTimeInMs < tmpDuration) {
            this.maxConfLoadedTimeInMs = tmpDuration;
        }
    }

    private void resetStatusInfo() {
        this.isDoneDataLoad = false;
        this.isDoneDataSub = false;
        this.isDoneDataPub = false;
        this.nextStepOpTimeInMills = 0L;
        this.curConfLoadTimeInMs = System.currentTimeMillis();
    }

    private boolean needForceSyncData() {
        return System.currentTimeMillis() - this.lastBrokerSyncTime > 0x6DDD00L;
    }
}

