/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;

public class TopicPSInfoManager {
    private final TMaster master;
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> topicPubInfoMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> topicSubInfoMap = new ConcurrentHashMap();

    public TopicPSInfoManager(TMaster master) {
        this.master = master;
    }

    public Set<String> getTopicSubInfo(String topic) {
        return (Set)this.topicSubInfoMap.get(topic);
    }

    public void addGroupSubTopicInfo(String groupName, Set<String> topicSet) {
        for (String topic : topicSet) {
            ConcurrentHashSet tmpGroupSet;
            ConcurrentHashSet groupSet = this.topicSubInfoMap.get(topic);
            if (groupSet == null && (groupSet = this.topicSubInfoMap.putIfAbsent(topic, (ConcurrentHashSet<String>)(tmpGroupSet = new ConcurrentHashSet()))) == null) {
                groupSet = tmpGroupSet;
            }
            groupSet.add((Object)groupName);
        }
    }

    public void rmvGroupSubTopicInfo(String group, Set<String> topicSet) {
        if (topicSet == null || group == null) {
            return;
        }
        for (String topic : topicSet) {
            ConcurrentHashSet<String> groupSet;
            if (topic == null || (groupSet = this.topicSubInfoMap.get(topic)) == null) continue;
            groupSet.remove((Object)group);
        }
    }

    public Set<String> getTopicPubInfo(String topic) {
        return (Set)this.topicPubInfoMap.get(topic);
    }

    public void addProducerTopicPubInfo(String producerId, Set<String> topicList) {
        for (String topic : topicList) {
            ConcurrentHashSet tmpProducerIdSet;
            ConcurrentHashSet producerIdSet = this.topicPubInfoMap.get(topic);
            if (producerIdSet == null && (producerIdSet = this.topicPubInfoMap.putIfAbsent(topic, (ConcurrentHashSet<String>)(tmpProducerIdSet = new ConcurrentHashSet()))) == null) {
                producerIdSet = tmpProducerIdSet;
            }
            producerIdSet.add((Object)producerId);
        }
    }

    public void rmvProducerTopicPubInfo(String producerId, Set<String> topicList) {
        if (topicList != null) {
            for (String topic : topicList) {
                ConcurrentHashSet<String> producerIdSet;
                if (topic == null || (producerIdSet = this.topicPubInfoMap.get(topic)) == null) continue;
                producerIdSet.remove((Object)producerId);
            }
        }
    }

    public void clear() {
        this.topicPubInfoMap.clear();
        this.topicSubInfoMap.clear();
    }

    public Set<String> getGroupSetWithSubTopic(Set<String> qryGroupSet, Set<String> subTopicSet) {
        HashSet<String> resultSet;
        block8: {
            block9: {
                resultSet = new HashSet<String>();
                if (!subTopicSet.isEmpty()) break block9;
                ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
                List<String> onlineGroups = consumerHolder.getAllGroupName();
                if (onlineGroups.isEmpty()) break block8;
                if (qryGroupSet.isEmpty()) {
                    resultSet.addAll(onlineGroups);
                } else {
                    for (String group : qryGroupSet) {
                        if (!onlineGroups.contains(group)) continue;
                        resultSet.add(group);
                    }
                }
                break block8;
            }
            if (qryGroupSet.isEmpty()) {
                for (String topic : subTopicSet) {
                    Set tmpGroupSet = (Set)this.topicSubInfoMap.get(topic);
                    if (tmpGroupSet == null || tmpGroupSet.isEmpty()) continue;
                    resultSet.addAll(tmpGroupSet);
                }
            } else {
                for (String topic : subTopicSet) {
                    Set tmpGroupSet = (Set)this.topicSubInfoMap.get(topic);
                    if (tmpGroupSet == null || tmpGroupSet.isEmpty()) continue;
                    for (String group : qryGroupSet) {
                        if (!tmpGroupSet.contains(group)) continue;
                        resultSet.add(group);
                    }
                    qryGroupSet.removeAll(resultSet);
                    if (!qryGroupSet.isEmpty()) continue;
                    break;
                }
            }
        }
        return resultSet;
    }
}

