/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.utils;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.daemon.AbstractDaemonService;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVisitTokenManager
extends AbstractDaemonService {
    private static final Logger logger = LoggerFactory.getLogger(SimpleVisitTokenManager.class);
    private final MasterConfig masterConfig;
    private final AtomicLong validVisitAuthorized = new AtomicLong(0L);
    private final AtomicLong freshVisitAuthorized = new AtomicLong(0L);
    private String brokerVisitTokens = "";

    public SimpleVisitTokenManager(MasterConfig masterConfig) {
        super("[VisitToken Manager]", masterConfig.getVisitTokenValidPeriodMs() * 4L / 5L);
        this.masterConfig = masterConfig;
        this.buildVisitTokens(true, new StringBuilder(512));
        super.start();
    }

    public long getCurVisitToken() {
        return this.validVisitAuthorized.get();
    }

    public long getFreshVisitToken() {
        return this.freshVisitAuthorized.get();
    }

    public String getBrokerVisitTokens() {
        return this.brokerVisitTokens;
    }

    protected void loopProcess(StringBuilder strBuff) {
        try {
            this.buildVisitTokens(false, strBuff);
        }
        catch (Throwable t) {
            logger.error("[VisitToken Manager] Daemon generator thread throw error ", t);
        }
    }

    public void close(long waitTimeMs) {
        if (super.stop()) {
            return;
        }
        logger.info("[VisitToken Manager] VisitToken Manager service stopped!");
    }

    private void buildVisitTokens(boolean initial, StringBuilder strBuff) {
        if (initial) {
            this.freshVisitAuthorized.set(System.currentTimeMillis());
            this.validVisitAuthorized.set(this.freshVisitAuthorized.get());
        } else {
            this.validVisitAuthorized.set(this.freshVisitAuthorized.getAndSet(System.currentTimeMillis()));
        }
        this.brokerVisitTokens = strBuff.append(this.validVisitAuthorized.get()).append(",").append(this.freshVisitAuthorized.get()).toString();
        strBuff.delete(0, strBuff.length());
    }
}

