/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.TopicProcessResult;

@Deprecated
public class WebAdminTopicAuthHandler
extends AbstractWebHandler {
    public WebAdminTopicAuthHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_topic_authorize_control", "adminQueryTopicAuthControl");
        this.registerModifyWebMethod("admin_set_topic_authorize_control", "adminEnableDisableTopicAuthControl");
        this.registerModifyWebMethod("admin_delete_topic_authorize_control", "adminDeleteTopicAuthControl");
        this.registerModifyWebMethod("admin_bath_add_topic_authorize_control", "adminBatchAddTopicAuthControl");
    }

    public StringBuilder adminQueryTopicAuthControl(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        TopicCtrlEntity qryEntity = new TopicCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        Map<String, TopicCtrlEntity> topicCtrlMap = this.defMetaDataService.getTopicCtrlConf(topicNameSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (TopicCtrlEntity entity : topicCtrlMap.values()) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"topicName\":\"").append(entity.getTopicName()).append("\",\"isEnable\":").append(entity.isAuthCtrlEnable()).append(",\"createUser\":\"").append(entity.getCreateUser()).append("\",\"createDate\":\"").append(entity.getCreateDateStr()).append("\",\"modifyUser\":\"").append(entity.getModifyUser()).append("\",\"modifyDate\":\"").append(entity.getModifyDateStr()).append("\",\"authConsumeGroup\":[");
            List<GroupConsumeCtrlEntity> groupEntity = this.defMetaDataService.getConsumeCtrlByTopic(entity.getTopicName());
            int j = 0;
            if (!groupEntity.isEmpty()) {
                for (GroupConsumeCtrlEntity itemEntity : groupEntity) {
                    if (j++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append("{\"topicName\":\"").append(itemEntity.getTopicName()).append("\",\"groupName\":\"").append(itemEntity.getGroupName()).append("\",\"createUser\":\"").append(itemEntity.getCreateUser()).append("\",\"createDate\":\"").append(itemEntity.getCreateDateStr()).append("\",\"modifyUser\":\"").append(itemEntity.getModifyUser()).append("\",\"modifyDate\":\"").append(itemEntity.getModifyDateStr()).append("\"}");
                }
            }
            sBuffer.append("],\"groupCount\":").append(j).append(",\"authFilterCondSet\":[");
            int y = 0;
            for (GroupConsumeCtrlEntity condEntity : groupEntity) {
                if (y++ > 0) {
                    sBuffer.append(",");
                }
                int condStatusId = condEntity.isEnableFilterConsume() ? 2 : 0;
                sBuffer.append("{\"topicName\":\"").append(condEntity.getTopicName()).append("\",\"groupName\":\"").append(condEntity.getGroupName()).append("\",\"condStatus\":").append(condStatusId);
                if (condEntity.getFilterCondStr().length() <= 2) {
                    sBuffer.append(",\"filterConds\":\"\"");
                } else {
                    sBuffer.append(",\"filterConds\":\"").append(condEntity.getFilterCondStr()).append("\"");
                }
                sBuffer.append(",\"createUser\":\"").append(condEntity.getCreateUser()).append("\",\"createDate\":\"").append(condEntity.getCreateDateStr()).append("\",\"modifyUser\":\"").append(condEntity.getModifyUser()).append("\",\"modifyDate\":\"").append(condEntity.getModifyDateStr()).append("\"}");
            }
            sBuffer.append("],\"filterCount\":").append(y).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminEnableDisableTopicAuthControl(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.ISENABLE, false, EnableStatus.STATUS_DISABLE, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus enableTopicAuth = (EnableStatus)((Object)result.getRetData());
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (String topicName : topicNameSet) {
            retInfo.add(this.defMetaDataService.insertTopicCtrlConf(opEntity, topicName, enableTopicAuth, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminBatchAddTopicAuthControl(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getTopicCtrlJsonSetInfo(req, opEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (TopicCtrlEntity topicCtrlInfo : addRecordMap.values()) {
            retInfo.add(this.defMetaDataService.insertTopicCtrlConf(topicCtrlInfo, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminDeleteTopicAuthControl(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (String topicName : topicNameSet) {
            TopicCtrlEntity ctrlEntity = this.defMetaDataService.getTopicCtrlByTopicName(topicName);
            if (ctrlEntity != null && ctrlEntity.getAuthCtrlStatus() != EnableStatus.STATUS_DISABLE) {
                retInfo.add(this.defMetaDataService.insertTopicCtrlConf(opEntity, topicName, EnableStatus.STATUS_DISABLE, sBuffer, result));
                continue;
            }
            result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
            retInfo.add(new TopicProcessResult(0, topicName, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private boolean getTopicCtrlJsonSetInfo(HttpServletRequest req, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.TOPICJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List deployJsonArray = (List)result.getRetData();
        HashMap<String, TopicCtrlEntity> addRecordMap = new HashMap<String, TopicCtrlEntity>();
        for (Map confMap : deployJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(confMap, true, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(confMap, WebFieldDef.TOPICNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String topicName = (String)result.getRetData();
            if (!WebParameterUtils.getEnableStatusValue(confMap, WebFieldDef.ISENABLE, false, EnableStatus.STATUS_DISABLE, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus enableTopicAuth = (EnableStatus)((Object)result.getRetData());
            TopicCtrlEntity itemConf = new TopicCtrlEntity(itemOpEntity, topicName);
            itemConf.updModifyInfo(itemOpEntity.getDataVerId(), -2, -2, enableTopicAuth);
            addRecordMap.put(itemConf.getTopicName(), itemConf);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record in ").append(WebFieldDef.TOPICJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private StringBuilder buildRetInfo(List<TopicProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (TopicProcessResult entry : retInfo) {
            if (entry == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"topicName\":\"").append(entry.getTopicName()).append("\"").append(",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }
}

