/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.model.ClusterGroupVO;
import org.apache.inlong.tubemq.server.master.web.model.ClusterNodeVO;

public class WebMasterInfoHandler
extends AbstractWebHandler {
    public WebMasterInfoHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_master_group_info", "getGroupAddressStrInfo");
        this.registerQueryWebMethod("admin_query_cluster_topic_view", "adminQueryClusterTopicView");
        this.registerQueryWebMethod("admin_query_group_info_by_topic", "adminGetOnlineGroupSetByTopic");
        this.registerQueryWebMethod("admin_query_cluster_default_setting", "adminQueryClusterDefSetting");
        this.registerModifyWebMethod("admin_transfer_current_master", "transferCurrentMaster");
        this.registerModifyWebMethod("admin_set_cluster_default_setting", "adminSetClusterDefSetting");
        this.registerModifyWebMethod("admin_update_cluster_default_setting", "adminUpdClusterDefSetting");
        this.registerQueryWebMethod("admin_query_def_flow_control_rule", "adminQueryDefFlowCtrlRule");
        this.registerModifyWebMethod("admin_set_def_flow_control_rule", "adminSetDefFlowControlRule");
        this.registerModifyWebMethod("admin_rmv_def_flow_control_rule", "adminDelDefFlowControlRule");
        this.registerModifyWebMethod("admin_upd_def_flow_control_rule", "adminModDefFlowCtrlRule");
    }

    public StringBuilder getGroupAddressStrInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        ClusterGroupVO clusterGroupVO = this.defMetaDataService.getGroupAddressStrInfo();
        if (clusterGroupVO == null) {
            WebParameterUtils.buildFailResultWithBlankData(500, "GetBrokerGroup info error", sBuffer);
        } else {
            sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Ok\",\"groupName\":\"").append(clusterGroupVO.getGroupName()).append("\",\"isPrimaryNodeActive\":").append(clusterGroupVO.isPrimaryNodeActive()).append(",\"data\":[");
            int count = 0;
            List<ClusterNodeVO> nodeList = clusterGroupVO.getNodeData();
            if (nodeList != null) {
                for (ClusterNodeVO node : nodeList) {
                    if (node == null) continue;
                    if (count++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append("{\"index\":").append(count).append(",\"name\":\"").append(node.getNodeName()).append("\",\"hostName\":\"").append(node.getHostName()).append("\",\"port\":\"").append(node.getPort()).append("\",\"statusInfo\":{").append("\"nodeStatus\":\"").append(node.getNodeStatus()).append("\",\"joinTime\":\"").append(node.getJoinTime()).append("\"}}");
                }
            }
            sBuffer.append("],\"count\":").append(count).append(",\"groupStatus\":\"").append(clusterGroupVO.getGroupStatus()).append("\"}");
        }
        return sBuffer;
    }

    public StringBuilder transferCurrentMaster(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        try {
            this.defMetaDataService.transferMaster();
            WebParameterUtils.buildSuccessResult(sBuffer, "TransferMaster method called, please wait 20 seconds!");
        }
        catch (Exception e2) {
            WebParameterUtils.buildFailResult(sBuffer, e2.getMessage());
        }
        return sBuffer;
    }

    public StringBuilder adminQueryClusterDefSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.buildRetInfo(sBuffer, true);
    }

    public StringBuilder adminQueryDefFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.buildRetInfo(sBuffer, false);
    }

    public StringBuilder adminSetClusterDefSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdDefFlowControlRule(req, sBuffer, result, true, true);
    }

    public StringBuilder adminUpdClusterDefSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdDefFlowControlRule(req, sBuffer, result, false, true);
    }

    public StringBuilder adminSetDefFlowControlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdDefFlowControlRule(req, sBuffer, result, true, false);
    }

    public StringBuilder adminModDefFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdDefFlowControlRule(req, sBuffer, result, false, false);
    }

    public StringBuilder adminQueryClusterTopicView(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        Map<String, List<TopicDeployEntity>> topicConfMap = this.defMetaDataService.getTopicConfMapByTopicAndBrokerIds(topicNameSet, brokerIds);
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        int totalCount = 0;
        int brokerCount = 0;
        int totalCfgNumPartCount = 0;
        int totalRunNumPartCount = 0;
        int totalCfgTopicStoreCount = 0;
        int totalRunTopicStoreCount = 0;
        boolean isSrvAcceptPublish = false;
        boolean isSrvAcceptSubscribe = false;
        boolean enableAuthControl = false;
        Tuple3 topicInfoTuple = new Tuple3();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<String, List<TopicDeployEntity>> entry : topicConfMap.entrySet()) {
            if (totalCount++ > 0) {
                sBuffer.append(",");
            }
            brokerCount = 0;
            totalCfgTopicStoreCount = 0;
            totalRunTopicStoreCount = 0;
            totalCfgNumPartCount = 0;
            totalRunNumPartCount = 0;
            isSrvAcceptPublish = false;
            isSrvAcceptSubscribe = false;
            enableAuthControl = false;
            for (TopicDeployEntity entity : entry.getValue()) {
                BrokerConfEntity brokerConfEntity = this.defMetaDataService.getBrokerConfByBrokerId(entity.getBrokerId());
                if (brokerConfEntity == null) continue;
                ++brokerCount;
                TopicPropGroup topicProps = entity.getTopicProps();
                totalCfgTopicStoreCount += topicProps.getNumTopicStores();
                totalCfgNumPartCount += topicProps.getNumPartitions() * topicProps.getNumTopicStores();
                brokerRunManager.getPubBrokerTopicInfo(entity.getBrokerId(), entity.getTopicName(), (Tuple3<Boolean, Boolean, TopicInfo>)topicInfoTuple);
                if (topicInfoTuple.getF2() == null) continue;
                if (((Boolean)topicInfoTuple.getF0()).booleanValue() && ((TopicInfo)topicInfoTuple.getF2()).isAcceptPublish()) {
                    isSrvAcceptPublish = true;
                }
                if (((Boolean)topicInfoTuple.getF1()).booleanValue() && ((TopicInfo)topicInfoTuple.getF2()).isAcceptSubscribe()) {
                    isSrvAcceptSubscribe = true;
                }
                totalRunTopicStoreCount += ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                totalRunNumPartCount += ((TopicInfo)topicInfoTuple.getF2()).getPartitionNum() * ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
            }
            TopicCtrlEntity authEntity = this.defMetaDataService.getTopicCtrlByTopicName(entry.getKey());
            if (authEntity != null) {
                enableAuthControl = authEntity.isAuthCtrlEnable();
            }
            sBuffer.append("{\"topicName\":\"").append(entry.getKey()).append("\",\"totalCfgBrokerCnt\":").append(brokerCount).append(",\"totalCfgNumStore\":").append(totalCfgTopicStoreCount).append(",\"totalRunNumStore\":").append(totalRunTopicStoreCount).append(",\"totalCfgNumPart\":").append(totalCfgNumPartCount).append(",\"totalRunNumPartCount\":").append(totalRunNumPartCount).append(",\"isSrvAcceptPublish\":").append(isSrvAcceptPublish).append(",\"isSrvAcceptSubscribe\":").append(isSrvAcceptSubscribe).append(",\"enableAuthControl\":").append(enableAuthControl).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCount);
        return sBuffer;
    }

    public StringBuilder adminGetOnlineGroupSetByTopic(HttpServletRequest req, StringBuilder strBuff, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        Set topicNameSet = (Set)result.getRetData();
        ConcurrentHashMap<String, ConcurrentHashSet<String>> topicGroupMap = this.master.getConsumerHolder().getRegTopicGroupMap();
        HashSet targetTopicSet = topicNameSet == null || topicNameSet.isEmpty() ? new HashSet(topicGroupMap.keySet()) : new HashSet(topicNameSet);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(strBuff);
        for (String topicName : targetTopicSet) {
            if (topicName == null) continue;
            if (totalCnt++ > 0) {
                strBuff.append(",");
            }
            int topicItemCnt = 0;
            ConcurrentHashSet<String> groupSet = topicGroupMap.get(topicName);
            strBuff.append("{\"topicName\":\"").append(topicName).append("\",\"groupSet\":[");
            if (groupSet != null) {
                for (String groupName : groupSet) {
                    if (topicItemCnt++ > 0) {
                        strBuff.append(",");
                    }
                    strBuff.append("\"").append(groupName).append("\"");
                }
            }
            strBuff.append("],\"groupCnt\":").append(topicItemCnt).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(strBuff, totalCnt);
        return strBuff;
    }

    public StringBuilder adminDelDefFlowControlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.defMetaDataService.addOrUpdClusterDefSetting(opEntity, -2, -2, -2, -2, -2, EnableStatus.STATUS_DISABLE, 0, "[]", null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        return this.buildRetInfo(sBuffer, false);
    }

    private StringBuilder innAddOrUpdDefFlowControlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp, boolean isNewVer) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.MAXMSGSIZEINMB, false, -2, 1, 20, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int maxMsgSizeMB = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int inBrokerPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERTLSPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int inBrokerTlsPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERWEBPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int inBrokerWebPort = (Integer)result.getRetData();
        TopicPropGroup defProps = null;
        if (isAddOp) {
            defProps = new TopicPropGroup();
            defProps.fillDefaultValue();
        }
        if (!WebParameterUtils.getTopicPropInfo(req, defProps, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicPropGroup inTopicProps = (TopicPropGroup)result.getRetData();
        if (!WebParameterUtils.getQryPriorityIdParameter(req, false, -2, 101, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int inQryPriorityId = (Integer)result.getRetData();
        if (isNewVer) {
            if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.FLOWCTRLENABLE, false, null, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return sBuffer;
            }
        } else if (!WebParameterUtils.getFlowCtrlStatusParamValue(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus flowCtrlEnable = (EnableStatus)((Object)result.getRetData());
        int flowRuleCnt = WebParameterUtils.getAndCheckFlowRules(req, isAddOp ? "[]" : null, sBuffer, result);
        if (!result.isSuccess()) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String flowCtrlInfo = (String)result.getRetData();
        if (!this.defMetaDataService.addOrUpdClusterDefSetting(opEntity, inBrokerPort, inBrokerTlsPort, inBrokerWebPort, maxMsgSizeMB, inQryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, inTopicProps, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        return this.buildRetInfo(sBuffer, isNewVer);
    }

    private StringBuilder buildRetInfo(StringBuilder sBuffer, boolean isNewVer) {
        int totalCnt = 0;
        ClusterSettingEntity curConf = this.defMetaDataService.getClusterDefSetting(true);
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        if (curConf != null) {
            ++totalCnt;
            if (isNewVer) {
                curConf.toWebJsonStr(sBuffer, true, true);
            } else {
                curConf.toOldVerFlowCtrlWebJsonStr(sBuffer, true);
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }
}

