/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;
import org.apache.inlong.tubemq.server.common.utils.HttpUtils;
import org.apache.inlong.tubemq.server.tools.cli.CliAbstractBase;
import org.apache.inlong.tubemq.server.tools.cli.CliBrokerAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliWebapiAdmin
extends CliAbstractBase {
    private static final Logger logger = LoggerFactory.getLogger(CliBrokerAdmin.class);
    private static final String defMasterPortal = "127.0.0.1:8080";
    private Map<String, Object> requestParams;

    public CliWebapiAdmin() {
        super(null);
        this.initCommandOptions();
    }

    public CliWebapiAdmin(Map<String, Object> requestParams) {
        this();
        this.requestParams = requestParams;
    }

    @Override
    protected void initCommandOptions() {
        this.addCommandOption(CliArgDef.MASTERPORTAL);
        this.addCommandOption(CliArgDef.ADMINMETHOD);
        this.addCommandOption(CliArgDef.METHOD);
    }

    @Override
    public boolean processParams(String[] args) throws Exception {
        String methodStr;
        CommandLine cli = this.parser.parse(this.options, args);
        if (cli == null) {
            throw new ParseException("Parse args failure");
        }
        if (cli.hasOption(CliArgDef.VERSION.longOpt)) {
            this.version();
        }
        if (cli.hasOption(CliArgDef.HELP.longOpt)) {
            this.help();
        }
        String masterAddr = defMasterPortal;
        if (cli.hasOption(CliArgDef.MASTERPORTAL.longOpt) && TStringUtils.isBlank((String)(masterAddr = cli.getOptionValue(CliArgDef.MASTERPORTAL.longOpt)))) {
            throw new Exception(CliArgDef.MASTERPORTAL.longOpt + " is required!");
        }
        JsonObject result = null;
        String masterUrl = "http://" + masterAddr + "/webapi.htm";
        if (cli.hasOption(CliArgDef.ADMINMETHOD.longOpt)) {
            HashMap<String, String> inParamMap = new HashMap<String, String>();
            inParamMap.put(CliArgDef.METHOD.longOpt, "admin_get_methods");
            result = HttpUtils.requestWebService(masterUrl, inParamMap);
            System.out.println(this.formatResult(result));
            System.exit(0);
        }
        if (TStringUtils.isBlank((String)(methodStr = cli.getOptionValue(CliArgDef.METHOD.longOpt)))) {
            throw new Exception(CliArgDef.METHOD.longOpt + " is required!");
        }
        this.requestParams.put(CliArgDef.METHOD.longOpt, methodStr);
        Map<String, String> convertedRequestParams = this.convertRequestParams(this.requestParams);
        result = HttpUtils.requestWebService(masterUrl, convertedRequestParams);
        String formattedResult = this.formatResult(result);
        System.out.println(formattedResult);
        return true;
    }

    private Map<String, String> convertRequestParams(Map<String, Object> requestParamsMap) {
        HashMap<String, String> converttedrequestParamsMap = new HashMap<String, String>();
        for (String k : requestParamsMap.keySet()) {
            converttedrequestParamsMap.put(k, String.valueOf(requestParamsMap.get(k)));
        }
        return converttedrequestParamsMap;
    }

    private String formatResult(JsonObject result) {
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)result);
    }

    public static void main(String[] args) {
        CliWebapiAdmin cliWebapiAdmin = new CliWebapiAdmin();
        try {
            cliWebapiAdmin.processParams(args);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            cliWebapiAdmin.help();
        }
    }
}

