/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.cursor.Cursor;
import org.apache.inlong.manager.dao.entity.AgentTaskConfigEntity;
import org.apache.inlong.manager.dao.entity.ClusterConfigEntity;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.dao.entity.ModuleConfigEntity;
import org.apache.inlong.manager.dao.entity.PackageConfigEntity;
import org.apache.inlong.manager.dao.entity.SortConfigEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.AgentTaskConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.ClusterConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.ModuleConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.PackageConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.SortConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sort.standalone.SortFieldInfo;
import org.apache.inlong.manager.pojo.sort.standalone.SortSourceClusterInfo;
import org.apache.inlong.manager.pojo.sort.standalone.SortSourceGroupInfo;
import org.apache.inlong.manager.pojo.sort.standalone.SortSourceStreamInfo;
import org.apache.inlong.manager.pojo.sort.standalone.SortSourceStreamSinkInfo;
import org.apache.inlong.manager.pojo.sort.standalone.SortTaskInfo;
import org.apache.inlong.manager.service.core.ConfigLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigLoaderImpl
implements ConfigLoader {
    @Autowired
    private InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    private StreamSinkEntityMapper streamSinkEntityMapper;
    @Autowired
    private StreamSinkFieldEntityMapper streamSinkFieldEntityMapper;
    @Autowired
    private InlongGroupEntityMapper inlongGroupEntityMapper;
    @Autowired
    private InlongGroupExtEntityMapper inlongGroupExtEntityMapper;
    @Autowired
    private InlongStreamExtEntityMapper inlongStreamExtEntityMapper;
    @Autowired
    private InlongStreamEntityMapper inlongStreamEntityMapper;
    @Autowired
    private DataNodeEntityMapper dataNodeEntityMapper;
    @Autowired
    private SortConfigEntityMapper sortConfigEntityMapper;
    @Autowired
    private ClusterConfigEntityMapper clusterConfigEntityMapper;
    @Autowired
    private AgentTaskConfigEntityMapper agentTaskConfigEntityMapper;
    @Autowired
    private ModuleConfigEntityMapper moduleConfigEntityMapper;
    @Autowired
    private PackageConfigEntityMapper packageConfigEntityMapper;

    @Override
    @Transactional
    public List<SortSourceClusterInfo> loadAllClusters() {
        Cursor cursor = this.clusterEntityMapper.selectAllClusters();
        ArrayList<SortSourceClusterInfo> allClusters = new ArrayList<SortSourceClusterInfo>();
        cursor.forEach(allClusters::add);
        return allClusters;
    }

    @Override
    @Transactional
    public List<SortSourceStreamSinkInfo> loadAllStreamSinks() {
        Cursor cursor = this.streamSinkEntityMapper.selectAllStreams();
        ArrayList<SortSourceStreamSinkInfo> allStreamSinks = new ArrayList<SortSourceStreamSinkInfo>();
        cursor.forEach(allStreamSinks::add);
        return allStreamSinks;
    }

    @Override
    @Transactional
    public List<SortSourceGroupInfo> loadAllGroup() {
        Cursor cursor = this.inlongGroupEntityMapper.selectAllGroups();
        ArrayList<SortSourceGroupInfo> allGroups = new ArrayList<SortSourceGroupInfo>();
        cursor.forEach(allGroups::add);
        return allGroups;
    }

    @Override
    @Transactional
    public List<InlongGroupExtEntity> loadGroupBackupInfo(String keyName) {
        Cursor cursor = this.inlongGroupExtEntityMapper.selectByKeyName(keyName);
        ArrayList<InlongGroupExtEntity> groupBackupInfo = new ArrayList<InlongGroupExtEntity>();
        cursor.forEach(groupBackupInfo::add);
        return groupBackupInfo;
    }

    @Override
    @Transactional
    public List<InlongStreamExtEntity> loadStreamBackupInfo(String keyName) {
        Cursor cursor = this.inlongStreamExtEntityMapper.selectByKeyName(keyName);
        ArrayList<InlongStreamExtEntity> streamBackupInfo = new ArrayList<InlongStreamExtEntity>();
        cursor.forEach(streamBackupInfo::add);
        return streamBackupInfo;
    }

    @Override
    @Transactional
    public List<SortSourceStreamInfo> loadAllStreams() {
        Cursor cursor = this.inlongStreamEntityMapper.selectAllStreams();
        ArrayList<SortSourceStreamInfo> allStreams = new ArrayList<SortSourceStreamInfo>();
        cursor.forEach(allStreams::add);
        return allStreams;
    }

    @Override
    @Transactional
    public List<StreamSinkEntity> loadAllStreamSinkEntity() {
        Cursor cursor = this.streamSinkEntityMapper.selectAllStreamSinks();
        ArrayList<StreamSinkEntity> allStreamSinks = new ArrayList<StreamSinkEntity>();
        cursor.forEach(allStreamSinks::add);
        return allStreamSinks;
    }

    @Override
    @Transactional
    public List<SortTaskInfo> loadAllTask() {
        Cursor cursor = this.streamSinkEntityMapper.selectAllTasks();
        ArrayList<SortTaskInfo> allTasks = new ArrayList<SortTaskInfo>();
        cursor.forEach(allTasks::add);
        return allTasks;
    }

    @Override
    @Transactional
    public List<DataNodeEntity> loadAllDataNodeEntity() {
        Cursor cursor = this.dataNodeEntityMapper.selectAllDataNodes();
        ArrayList<DataNodeEntity> allDataNodes = new ArrayList<DataNodeEntity>();
        cursor.forEach(allDataNodes::add);
        return allDataNodes;
    }

    @Override
    @Transactional
    public List<SortFieldInfo> loadAllFields() {
        Cursor cursor = this.streamSinkFieldEntityMapper.selectAllFields();
        ArrayList<SortFieldInfo> allFields = new ArrayList<SortFieldInfo>();
        cursor.forEach(allFields::add);
        return allFields;
    }

    @Override
    @Transactional
    public List<SortConfigEntity> loadAllSortConfigEntity() {
        Cursor cursor = this.sortConfigEntityMapper.selectAllSortConfigs();
        ArrayList<SortConfigEntity> allSortConfigs = new ArrayList<SortConfigEntity>();
        cursor.forEach(allSortConfigs::add);
        return allSortConfigs;
    }

    @Override
    @Transactional
    public List<ClusterConfigEntity> loadAllClusterConfigEntity() {
        Cursor cursor = this.clusterConfigEntityMapper.selectAllClusterConfigs();
        ArrayList<ClusterConfigEntity> allClusterConfigs = new ArrayList<ClusterConfigEntity>();
        cursor.forEach(allClusterConfigs::add);
        return allClusterConfigs;
    }

    @Override
    @Transactional
    public List<AgentTaskConfigEntity> loadAllAgentTaskConfigEntity() {
        Cursor cursor = this.agentTaskConfigEntityMapper.selectAllAgentTaskConfigs();
        ArrayList<AgentTaskConfigEntity> agentTaskConfigEntityList = new ArrayList<AgentTaskConfigEntity>();
        cursor.forEach(agentTaskConfigEntityList::add);
        return agentTaskConfigEntityList;
    }

    @Override
    @Transactional
    public List<ModuleConfigEntity> loadAllModuleConfigEntity() {
        Cursor cursor = this.moduleConfigEntityMapper.selectAllModuleConfigs();
        ArrayList<ModuleConfigEntity> moduleConfigEntityList = new ArrayList<ModuleConfigEntity>();
        cursor.forEach(moduleConfigEntityList::add);
        return moduleConfigEntityList;
    }

    @Override
    @Transactional
    public List<PackageConfigEntity> loadAllPackageConfigEntity() {
        Cursor cursor = this.packageConfigEntityMapper.selectAllPackageConfigs();
        ArrayList<PackageConfigEntity> packageConfigEntityList = new ArrayList<PackageConfigEntity>();
        cursor.forEach(packageConfigEntityList::add);
        return packageConfigEntityList;
    }
}

