/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.pulsar;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.sort.node.NodeConfig;
import org.apache.inlong.common.pojo.sort.node.PulsarNodeConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeDTO;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeInfo;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.queue.pulsar.PulsarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PulsarDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "PULSAR";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        PulsarDataNodeInfo pulsarDataNodeInfo = new PulsarDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)pulsarDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            PulsarDataNodeDTO dto = PulsarDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)pulsarDataNodeInfo);
        }
        return pulsarDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        PulsarDataNodeRequest nodeRequest = (PulsarDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)nodeRequest, (Object)targetEntity, (boolean)true);
        try {
            PulsarDataNodeDTO dto = PulsarDataNodeDTO.getFromRequest((PulsarDataNodeRequest)nodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for pulsar node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        PulsarDataNodeRequest pulsarDataNodeRequest = (PulsarDataNodeRequest)request;
        String adminUrl = pulsarDataNodeRequest.getAdminUrl();
        String token = pulsarDataNodeRequest.getToken();
        Preconditions.expectNotBlank((String)adminUrl, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection admin urlcannot be empty");
        if (this.getPulsarConnection(adminUrl, token)) {
            LOGGER.info("pulsar  connection success for adminUrl={}, token={}", (Object)adminUrl, (Object)token);
        }
        return true;
    }

    private boolean getPulsarConnection(String adminUrl, String token) {
        PulsarClusterInfo pulsarClusterInfo = ((PulsarClusterInfo.PulsarClusterInfoBuilder)PulsarClusterInfo.builder().adminUrl(adminUrl).token(token)).build();
        try {
            PulsarUtils.getTenants(this.restTemplate, pulsarClusterInfo);
            return true;
        }
        catch (Exception e) {
            String errMsg = String.format("Pulsar connection failed for AdminUrl=%s", pulsarClusterInfo.getAdminUrl());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }

    @Override
    public NodeConfig getNodeConfig(DataNodeEntity dataNodeEntity) {
        DataNodeInfo dataNodeInfo = this.getFromEntity(dataNodeEntity);
        PulsarNodeConfig pulsarNodeConfig = (PulsarNodeConfig)CommonBeanUtils.copyProperties((Object)dataNodeInfo, PulsarNodeConfig::new);
        PulsarDataNodeDTO dto = PulsarDataNodeDTO.getFromJson((String)dataNodeEntity.getExtParams());
        CommonBeanUtils.copyProperties((Object)dto, (Object)pulsarNodeConfig);
        pulsarNodeConfig.setNodeName(dataNodeInfo.getName());
        return pulsarNodeConfig;
    }
}

