/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.common.pojo.sort.dataflow.field.FieldConfig;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.sink.HttpSinkConfig;
import org.apache.inlong.common.pojo.sort.dataflow.sink.SinkConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.node.http.HttpDataNodeDTO;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.http.HttpSink;
import org.apache.inlong.manager.pojo.sink.http.HttpSinkDTO;
import org.apache.inlong.manager.pojo.sink.http.HttpSinkRequest;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSinkOperator.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DataNodeEntityMapper dataNodeEntityMapper;

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        HttpSinkRequest sinkRequest = (HttpSinkRequest)request;
        try {
            HttpSinkDTO dto = HttpSinkDTO.getFromRequest((HttpSinkRequest)sinkRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of http SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    protected String getSinkType() {
        return "HTTP";
    }

    @Override
    public Boolean accept(String sinkType) {
        return "HTTP".equals(sinkType);
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        HttpSink sink = new HttpSink();
        if (entity == null) {
            return sink;
        }
        HttpSinkDTO dto = HttpSinkDTO.getFromJson((String)entity.getExtParams());
        DataNodeEntity dataNodeEntity = this.dataNodeEntityMapper.selectByUniqueKey(entity.getDataNodeName(), "HTTP");
        HttpDataNodeDTO httpDataNodeDTO = (HttpDataNodeDTO)JsonUtils.parseObject((String)dataNodeEntity.getExtParams(), HttpDataNodeDTO.class);
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)httpDataNodeDTO, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = this.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }

    @Override
    public SinkConfig getSinkConfig(InlongGroupInfo groupInfo, InlongStreamInfo streamInfo, StreamSink sink) {
        HttpSink httpSink = (HttpSink)sink;
        HttpSinkConfig sinkConfig = (HttpSinkConfig)CommonBeanUtils.copyProperties((Object)httpSink, HttpSinkConfig::new);
        List fields = this.sinkFieldMapper.selectBySinkId(sink.getId()).stream().map(v -> {
            FieldConfig fieldConfig = new FieldConfig();
            FormatInfo formatInfo = FieldInfoUtils.convertFieldFormat((String)v.getFieldType().toLowerCase());
            fieldConfig.setName(v.getFieldName());
            fieldConfig.setFormatInfo(formatInfo);
            return fieldConfig;
        }).collect(Collectors.toList());
        sinkConfig.setFieldConfigs(fields);
        return sinkConfig;
    }
}

