/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;

public class TStringUtils {
    public static final String EMPTY = "";

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty((CharSequence)str);
    }

    public static boolean isNotEmpty(String str) {
        return StringUtils.isNotEmpty((CharSequence)str);
    }

    public static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public static boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((CharSequence)str);
    }

    public static String trim(String str) {
        return StringUtils.trim((String)str);
    }

    public static int getLevenshteinDistance(String s, String t) {
        return StringUtils.getLevenshteinDistance((CharSequence)s, (CharSequence)t);
    }

    public static boolean isLetter(char ch) {
        return Character.isUpperCase(ch) || Character.isLowerCase(ch);
    }

    public static boolean isLetterOrDigit(char ch) {
        return TStringUtils.isLetter(ch) || Character.isDigit(ch);
    }

    public static String toCamelCase(String origStr) {
        if (TStringUtils.isEmpty(origStr)) {
            return origStr;
        }
        origStr = origStr.trim();
        int length = origStr.length();
        int curWritePos = 0;
        boolean upperCaseNext = false;
        char[] tgtStr = new char[length];
        int index = 0;
        while (index < length) {
            char curChar = origStr.charAt(index);
            index += Character.charCount(curChar);
            if (Character.isWhitespace(curChar)) continue;
            if (TStringUtils.isLetter(curChar)) {
                if (upperCaseNext) {
                    upperCaseNext = false;
                    curChar = Character.toUpperCase(curChar);
                } else if (curWritePos == 0) {
                    curChar = Character.toLowerCase(curChar);
                } else {
                    char preChar = tgtStr[curWritePos - 1];
                    if (!TStringUtils.isLetterOrDigit(preChar)) {
                        curChar = Character.toLowerCase(curChar);
                    } else if (Character.isUpperCase(preChar)) {
                        curChar = Character.toLowerCase(curChar);
                    }
                }
                tgtStr[curWritePos++] = curChar;
                continue;
            }
            if (curChar == '_') {
                upperCaseNext = true;
                continue;
            }
            tgtStr[curWritePos++] = curChar;
        }
        return new String(tgtStr, 0, curWritePos);
    }

    public static String getAuthSignature(String usrName, String usrPassWord, long timestamp, int randomValue) {
        Base64 base64 = new Base64();
        StringBuilder sbuf = new StringBuilder(512);
        byte[] baseStr = base64.encode(new HmacUtils(HmacAlgorithms.HMAC_SHA_1, usrPassWord).hmac(sbuf.append(usrName).append(timestamp).append(randomValue).toString()));
        sbuf.delete(0, sbuf.length());
        String signature = EMPTY;
        try {
            signature = URLEncoder.encode(new String(baseStr, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }

    public static String setAttrValToAttributes(String srcAttrs, String attrKey, String attrVal) {
        String[] strAttrs;
        StringBuilder sbuf = new StringBuilder(512);
        if (TStringUtils.isBlank(srcAttrs)) {
            return sbuf.append(attrKey).append("=").append(attrVal).toString();
        }
        if (!srcAttrs.contains(attrKey)) {
            return sbuf.append(srcAttrs).append("#").append(attrKey).append("=").append(attrVal).toString();
        }
        boolean notFirst = false;
        for (String strAttrItem : strAttrs = srcAttrs.split("#")) {
            if (!TStringUtils.isNotBlank(strAttrItem)) continue;
            if (notFirst) {
                sbuf.append("#");
            }
            if (strAttrItem.contains(attrKey)) {
                sbuf.append(attrKey).append("=").append(attrVal);
            } else {
                sbuf.append(strAttrItem);
            }
            notFirst = true;
        }
        return sbuf.toString();
    }

    public static String getAttrValFrmAttributes(String srcAttrs, String attrKey) {
        if (!TStringUtils.isBlank(srcAttrs)) {
            String[] strAttrs;
            for (String attrItem : strAttrs = srcAttrs.split("#")) {
                String[] kv;
                if (!TStringUtils.isNotBlank(attrItem) || !attrKey.equals((kv = attrItem.split("="))[0])) continue;
                if (kv.length == 1) {
                    return EMPTY;
                }
                return kv[1];
            }
        }
        return null;
    }
}

