/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.data.Envelope;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.signal.Signal;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.relational.history.ConnectTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher<T extends DataCollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
    private final TopicSelector<T> topicSelector;
    private final DatabaseSchema<T> schema;
    private final HistorizedDatabaseSchema<T> historizedSchema;
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final DataCollectionFilters.DataCollectionFilter<T> filter;
    private final ChangeEventCreator changeEventCreator;
    private final Heartbeat heartbeat;
    private DataChangeEventListener eventListener = DataChangeEventListener.NO_OP;
    private final boolean emitTombstonesOnDelete;
    private final InconsistentSchemaHandler<T> inconsistentSchemaHandler;
    private final TransactionMonitor transactionMonitor;
    private final CommonConnectorConfig connectorConfig;
    private final EnumSet<Envelope.Operation> skippedOperations;
    private final boolean neverSkip;
    private final Schema schemaChangeKeySchema;
    private final Schema schemaChangeValueSchema;
    private final TableChanges.TableChangesSerializer<List<Struct>> tableChangesSerializer = new ConnectTableChangeSerializer();
    private final Signal signal;
    private IncrementalSnapshotChangeEventSource<T> incrementalSnapshotChangeEventSource;
    private final StreamingChangeRecordReceiver streamingReceiver;

    public EventDispatcher(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, DatabaseSchema<T> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<T> filter, ChangeEventCreator changeEventCreator, EventMetadataProvider metadataProvider, SchemaNameAdjuster schemaNameAdjuster) {
        this(connectorConfig, topicSelector, schema, queue, filter, changeEventCreator, null, metadataProvider, null, schemaNameAdjuster, null);
    }

    public EventDispatcher(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, DatabaseSchema<T> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<T> filter, ChangeEventCreator changeEventCreator, EventMetadataProvider metadataProvider, Heartbeat heartbeat, SchemaNameAdjuster schemaNameAdjuster) {
        this(connectorConfig, topicSelector, schema, queue, filter, changeEventCreator, null, metadataProvider, heartbeat, schemaNameAdjuster, null);
    }

    public EventDispatcher(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, DatabaseSchema<T> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<T> filter, ChangeEventCreator changeEventCreator, InconsistentSchemaHandler<T> inconsistentSchemaHandler, EventMetadataProvider metadataProvider, Heartbeat customHeartbeat, SchemaNameAdjuster schemaNameAdjuster, JdbcConnection jdbcConnection) {
        this.connectorConfig = connectorConfig;
        this.topicSelector = topicSelector;
        this.schema = schema;
        this.historizedSchema = schema.isHistorized() ? (HistorizedDatabaseSchema)schema : null;
        this.queue = queue;
        this.filter = filter;
        this.changeEventCreator = changeEventCreator;
        this.streamingReceiver = new StreamingChangeRecordReceiver();
        this.emitTombstonesOnDelete = connectorConfig.isEmitTombstoneOnDelete();
        this.inconsistentSchemaHandler = inconsistentSchemaHandler != null ? inconsistentSchemaHandler : this::errorOnMissingSchema;
        this.skippedOperations = connectorConfig.getSkippedOperations();
        this.neverSkip = connectorConfig.supportsOperationFiltering() || this.skippedOperations.isEmpty();
        this.transactionMonitor = new TransactionMonitor(connectorConfig, metadataProvider, this::enqueueTransactionMessage);
        this.signal = new Signal(connectorConfig, this);
        this.heartbeat = customHeartbeat != null ? customHeartbeat : Heartbeat.create(connectorConfig.getHeartbeatInterval(), topicSelector.getHeartbeatTopic(), connectorConfig.getLogicalName());
        this.schemaChangeKeySchema = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector." + connectorConfig.getConnectorName() + ".SchemaChangeKey")).field("databaseName", Schema.STRING_SCHEMA).build();
        this.schemaChangeValueSchema = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector." + connectorConfig.getConnectorName() + ".SchemaChangeValue")).field("source", connectorConfig.getSourceInfoStructMaker().schema()).field("databaseName", Schema.OPTIONAL_STRING_SCHEMA).field("schemaName", Schema.OPTIONAL_STRING_SCHEMA).field("ddl", Schema.OPTIONAL_STRING_SCHEMA).field("tableChanges", SchemaBuilder.array((Schema)ConnectTableChangeSerializer.CHANGE_SCHEMA).build()).build();
    }

    public void dispatchSnapshotEvent(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter, final SnapshotReceiver receiver) throws InterruptedException {
        final DataCollectionSchema dataCollectionSchema = this.schema.schemaFor(dataCollectionId);
        if (dataCollectionSchema == null) {
            this.errorOnMissingSchema(dataCollectionId, changeRecordEmitter);
        }
        changeRecordEmitter.emitChangeRecords(dataCollectionSchema, new ChangeRecordEmitter.Receiver(){

            @Override
            public void changeRecord(Partition partition, DataCollectionSchema schema, Envelope.Operation operation, Object key, Struct value, OffsetContext offset, ConnectHeaders headers) throws InterruptedException {
                EventDispatcher.this.eventListener.onEvent(dataCollectionSchema.id(), offset, key, value);
                receiver.changeRecord(partition, dataCollectionSchema, operation, key, value, offset, headers);
            }
        });
    }

    public SnapshotReceiver getSnapshotChangeEventReceiver() {
        return new BufferingSnapshotChangeRecordReceiver();
    }

    public SnapshotReceiver getIncrementalSnapshotChangeEventReceiver(DataChangeEventListener dataListener) {
        return new IncrementalSnapshotChangeRecordReceiver(dataListener);
    }

    public boolean dispatchDataChangeEvent(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter) throws InterruptedException {
        try {
            boolean handled = false;
            if (!this.filter.isIncluded(dataCollectionId)) {
                LOGGER.trace("Filtered data change event for {}", dataCollectionId);
                this.eventListener.onFilteredEvent("source = " + dataCollectionId);
                this.dispatchFilteredEvent(changeRecordEmitter.getPartition(), changeRecordEmitter.getOffset());
            } else {
                DataCollectionSchema dataCollectionSchema = this.schema.schemaFor(dataCollectionId);
                if (dataCollectionSchema == null) {
                    Optional<DataCollectionSchema> replacementSchema = this.inconsistentSchemaHandler.handle(dataCollectionId, changeRecordEmitter);
                    if (!replacementSchema.isPresent()) {
                        return false;
                    }
                    dataCollectionSchema = replacementSchema.get();
                }
                changeRecordEmitter.emitChangeRecords(dataCollectionSchema, new ChangeRecordEmitter.Receiver((DataCollectionId)dataCollectionId){
                    final /* synthetic */ DataCollectionId val$dataCollectionId;
                    {
                        this.val$dataCollectionId = dataCollectionId;
                    }

                    @Override
                    public void changeRecord(Partition partition, DataCollectionSchema schema, Envelope.Operation operation, Object key, Struct value, OffsetContext offset, ConnectHeaders headers) throws InterruptedException {
                        if (operation == Envelope.Operation.CREATE && EventDispatcher.this.signal.isSignal(this.val$dataCollectionId)) {
                            EventDispatcher.this.signal.process(partition, value, offset);
                        }
                        if (EventDispatcher.this.neverSkip || !EventDispatcher.this.skippedOperations.contains((Object)operation)) {
                            EventDispatcher.this.transactionMonitor.dataEvent(partition, this.val$dataCollectionId, offset, key, value);
                            EventDispatcher.this.eventListener.onEvent(this.val$dataCollectionId, offset, key, value);
                            if (EventDispatcher.this.incrementalSnapshotChangeEventSource != null) {
                                EventDispatcher.this.incrementalSnapshotChangeEventSource.processMessage(partition, this.val$dataCollectionId, key, offset);
                            }
                            EventDispatcher.this.streamingReceiver.changeRecord(partition, schema, operation, key, value, offset, headers);
                        }
                    }
                });
                handled = true;
            }
            this.heartbeat.heartbeat(changeRecordEmitter.getPartition().getSourcePartition(), changeRecordEmitter.getOffset().getOffset(), this::enqueueHeartbeat);
            return handled;
        }
        catch (Exception e) {
            switch (this.connectorConfig.getEventProcessingFailureHandlingMode()) {
                case FAIL: {
                    throw new ConnectException("Error while processing event at offset " + changeRecordEmitter.getOffset().getOffset(), (Throwable)e);
                }
                case WARN: {
                    LOGGER.warn("Error while processing event at offset {}", changeRecordEmitter.getOffset().getOffset());
                    break;
                }
                case SKIP: {
                    LOGGER.debug("Error while processing event at offset {}", changeRecordEmitter.getOffset().getOffset());
                }
            }
            return false;
        }
    }

    public void dispatchFilteredEvent(Partition partition, OffsetContext offset) throws InterruptedException {
        if (this.incrementalSnapshotChangeEventSource != null) {
            this.incrementalSnapshotChangeEventSource.processFilteredEvent(partition, offset);
        }
    }

    public void dispatchTransactionCommittedEvent(Partition partition, OffsetContext offset) throws InterruptedException {
        this.transactionMonitor.transactionComittedEvent(partition, offset);
        if (this.incrementalSnapshotChangeEventSource != null) {
            this.incrementalSnapshotChangeEventSource.processTransactionCommittedEvent(partition, offset);
        }
    }

    public void dispatchTransactionStartedEvent(Partition partition, String transactionId, OffsetContext offset) throws InterruptedException {
        this.transactionMonitor.transactionStartedEvent(partition, transactionId, offset);
        if (this.incrementalSnapshotChangeEventSource != null) {
            this.incrementalSnapshotChangeEventSource.processTransactionStartedEvent(partition, offset);
        }
    }

    public void dispatchConnectorEvent(ConnectorEvent event) {
        this.eventListener.onConnectorEvent(event);
    }

    public Optional<DataCollectionSchema> errorOnMissingSchema(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter) {
        this.eventListener.onErroneousEvent("source = " + dataCollectionId);
        throw new IllegalArgumentException("No metadata registered for captured table " + dataCollectionId);
    }

    public Optional<DataCollectionSchema> ignoreMissingSchema(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter) {
        return Optional.empty();
    }

    public void dispatchSchemaChangeEvent(T dataCollectionId, SchemaChangeEventEmitter schemaChangeEventEmitter) throws InterruptedException {
        if (dataCollectionId != null && !this.filter.isIncluded(dataCollectionId) && (this.historizedSchema == null || this.historizedSchema.storeOnlyCapturedTables())) {
            LOGGER.trace("Filtering schema change event for {}", dataCollectionId);
            return;
        }
        schemaChangeEventEmitter.emitSchemaChangeEvent(new SchemaChangeEventReceiver());
    }

    public void dispatchSchemaChangeEvent(Collection<T> dataCollectionIds, SchemaChangeEventEmitter schemaChangeEventEmitter) throws InterruptedException {
        boolean anyNonfilteredEvent = false;
        if (dataCollectionIds == null || dataCollectionIds.isEmpty()) {
            anyNonfilteredEvent = true;
        } else {
            for (DataCollectionId dataCollectionId : dataCollectionIds) {
                if (!this.filter.isIncluded(dataCollectionId)) continue;
                anyNonfilteredEvent = true;
                break;
            }
        }
        if (!anyNonfilteredEvent && (this.historizedSchema == null || this.historizedSchema.storeOnlyCapturedTables())) {
            LOGGER.trace("Filtering schema change event for {}", dataCollectionIds);
            return;
        }
        schemaChangeEventEmitter.emitSchemaChangeEvent(new SchemaChangeEventReceiver());
    }

    public void alwaysDispatchHeartbeatEvent(Partition partition, OffsetContext offset) throws InterruptedException {
        this.heartbeat.forcedBeat(partition.getSourcePartition(), offset.getOffset(), this::enqueueHeartbeat);
    }

    public void dispatchHeartbeatEvent(Partition partition, OffsetContext offset) throws InterruptedException {
        this.heartbeat.heartbeat(partition.getSourcePartition(), offset.getOffset(), this::enqueueHeartbeat);
    }

    public boolean heartbeatsEnabled() {
        return this.heartbeat.isEnabled();
    }

    private void enqueueHeartbeat(SourceRecord record) throws InterruptedException {
        this.queue.enqueue(new DataChangeEvent(record));
    }

    private void enqueueTransactionMessage(SourceRecord record) throws InterruptedException {
        this.queue.enqueue(new DataChangeEvent(record));
    }

    private void enqueueSchemaChangeMessage(SourceRecord record) throws InterruptedException {
        this.queue.enqueue(new DataChangeEvent(record));
    }

    public void dispatchServerHeartbeatEvent(Partition partition, OffsetContext offset) throws InterruptedException {
        if (this.incrementalSnapshotChangeEventSource != null) {
            this.incrementalSnapshotChangeEventSource.processHeartbeat(partition, offset);
        }
    }

    public void setEventListener(DataChangeEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setIncrementalSnapshotChangeEventSource(Optional<IncrementalSnapshotChangeEventSource<? extends DataCollectionId>> incrementalSnapshotChangeEventSource) {
        this.incrementalSnapshotChangeEventSource = incrementalSnapshotChangeEventSource.orElse(null);
    }

    public DatabaseSchema<T> getSchema() {
        return this.schema;
    }

    public HistorizedDatabaseSchema<T> getHistorizedSchema() {
        return this.historizedSchema;
    }

    public IncrementalSnapshotChangeEventSource<T> getIncrementalSnapshotChangeEventSource() {
        return this.incrementalSnapshotChangeEventSource;
    }

    @FunctionalInterface
    public static interface InconsistentSchemaHandler<T extends DataCollectionId> {
        public Optional<DataCollectionSchema> handle(T var1, ChangeRecordEmitter var2);
    }

    private final class SchemaChangeEventReceiver
    implements SchemaChangeEventEmitter.Receiver {
        private SchemaChangeEventReceiver() {
        }

        private Struct schemaChangeRecordKey(SchemaChangeEvent event) {
            Struct result = new Struct(EventDispatcher.this.schemaChangeKeySchema);
            result.put("databaseName", (Object)event.getDatabase());
            return result;
        }

        private Struct schemaChangeRecordValue(SchemaChangeEvent event) {
            Struct result = new Struct(EventDispatcher.this.schemaChangeValueSchema);
            result.put("source", (Object)event.getSource());
            result.put("databaseName", (Object)event.getDatabase());
            result.put("schemaName", (Object)event.getSchema());
            result.put("ddl", (Object)event.getDdl());
            result.put("tableChanges", EventDispatcher.this.tableChangesSerializer.serialize(event.getTableChanges()));
            return result;
        }

        @Override
        public void schemaChangeEvent(SchemaChangeEvent event) throws InterruptedException {
            EventDispatcher.this.historizedSchema.applySchemaChange(event);
            if (EventDispatcher.this.connectorConfig.isSchemaChangesHistoryEnabled()) {
                String topicName = EventDispatcher.this.topicSelector.getPrimaryTopic();
                Integer partition = 0;
                Struct key = this.schemaChangeRecordKey(event);
                Struct value = this.schemaChangeRecordValue(event);
                SourceRecord record = new SourceRecord(event.getPartition(), event.getOffset(), topicName, partition, EventDispatcher.this.schemaChangeKeySchema, (Object)key, EventDispatcher.this.schemaChangeValueSchema, (Object)value);
                EventDispatcher.this.enqueueSchemaChangeMessage(record);
            }
        }
    }

    private final class IncrementalSnapshotChangeRecordReceiver
    implements SnapshotReceiver {
        public final DataChangeEventListener dataListener;

        public IncrementalSnapshotChangeRecordReceiver(DataChangeEventListener dataListener) {
            this.dataListener = dataListener;
        }

        @Override
        public void changeRecord(Partition partition, DataCollectionSchema dataCollectionSchema, Envelope.Operation operation, Object key, Struct value, OffsetContext offsetContext, ConnectHeaders headers) throws InterruptedException {
            Objects.requireNonNull(value, "value must not be null");
            LOGGER.trace("Received change record for {} operation on key {}", (Object)operation, key);
            Schema keySchema = dataCollectionSchema.keySchema();
            String topicName = EventDispatcher.this.topicSelector.topicNameFor(dataCollectionSchema.id());
            SourceRecord record = new SourceRecord(partition.getSourcePartition(), offsetContext.getOffset(), topicName, null, keySchema, key, dataCollectionSchema.getEnvelopeSchema().schema(), (Object)value, null, (Iterable)headers);
            this.dataListener.onEvent(dataCollectionSchema.id(), offsetContext, keySchema, value);
            EventDispatcher.this.queue.enqueue(EventDispatcher.this.changeEventCreator.createDataChangeEvent(record));
        }

        @Override
        public void completeSnapshot() throws InterruptedException {
        }
    }

    private final class BufferingSnapshotChangeRecordReceiver
    implements SnapshotReceiver {
        private Supplier<DataChangeEvent> bufferedEvent;

        private BufferingSnapshotChangeRecordReceiver() {
        }

        @Override
        public void changeRecord(Partition partition, DataCollectionSchema dataCollectionSchema, Envelope.Operation operation, Object key, Struct value, OffsetContext offsetContext, ConnectHeaders headers) throws InterruptedException {
            Objects.requireNonNull(value, "value must not be null");
            LOGGER.trace("Received change record for {} operation on key {}", (Object)operation, key);
            if (this.bufferedEvent != null) {
                EventDispatcher.this.queue.enqueue(this.bufferedEvent.get());
            }
            Schema keySchema = dataCollectionSchema.keySchema();
            String topicName = EventDispatcher.this.topicSelector.topicNameFor(dataCollectionSchema.id());
            this.bufferedEvent = () -> {
                SourceRecord record = new SourceRecord(partition.getSourcePartition(), offsetContext.getOffset(), topicName, null, keySchema, key, dataCollectionSchema.getEnvelopeSchema().schema(), (Object)value, null, (Iterable)headers);
                return EventDispatcher.this.changeEventCreator.createDataChangeEvent(record);
            };
        }

        @Override
        public void completeSnapshot() throws InterruptedException {
            if (this.bufferedEvent != null) {
                Struct source;
                SnapshotRecord snapshot;
                DataChangeEvent event = this.bufferedEvent.get();
                Struct envelope = (Struct)event.getRecord().value();
                if (envelope.schema().field("source") != null && (snapshot = SnapshotRecord.fromSource(source = envelope.getStruct("source"))) == SnapshotRecord.TRUE) {
                    SnapshotRecord.LAST.toSource(source);
                }
                EventDispatcher.this.queue.enqueue(event);
                this.bufferedEvent = null;
            }
        }
    }

    private final class StreamingChangeRecordReceiver
    implements ChangeRecordEmitter.Receiver {
        private StreamingChangeRecordReceiver() {
        }

        @Override
        public void changeRecord(Partition partition, DataCollectionSchema dataCollectionSchema, Envelope.Operation operation, Object key, Struct value, OffsetContext offsetContext, ConnectHeaders headers) throws InterruptedException {
            Objects.requireNonNull(value, "value must not be null");
            LOGGER.trace("Received change record for {} operation on key {}", (Object)operation, key);
            Schema keySchema = key == null && operation == Envelope.Operation.TRUNCATE ? null : dataCollectionSchema.keySchema();
            String topicName = EventDispatcher.this.topicSelector.topicNameFor(dataCollectionSchema.id());
            SourceRecord record = new SourceRecord(partition.getSourcePartition(), offsetContext.getOffset(), topicName, null, keySchema, key, dataCollectionSchema.getEnvelopeSchema().schema(), (Object)value, null, (Iterable)headers);
            EventDispatcher.this.queue.enqueue(EventDispatcher.this.changeEventCreator.createDataChangeEvent(record));
            if (EventDispatcher.this.emitTombstonesOnDelete && operation == Envelope.Operation.DELETE) {
                SourceRecord tombStone = record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), null, null, record.timestamp(), (Iterable)record.headers());
                EventDispatcher.this.queue.enqueue(EventDispatcher.this.changeEventCreator.createDataChangeEvent(tombStone));
            }
        }
    }

    public static interface SnapshotReceiver
    extends ChangeRecordEmitter.Receiver {
        public void completeSnapshot() throws InterruptedException;
    }
}

