/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InlongTenantRoleApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.TenantRoleInfo;
import org.apache.inlong.manager.pojo.user.TenantRolePageRequest;
import org.apache.inlong.manager.pojo.user.TenantRoleRequest;

public class InlongTenantRoleClient {
    private final InlongTenantRoleApi inlongTenantRoleApi;

    public InlongTenantRoleClient(ClientConfiguration configuration) {
        this.inlongTenantRoleApi = (InlongTenantRoleApi)ClientUtils.createRetrofit(configuration).create(InlongTenantRoleApi.class);
    }

    public PageResult<TenantRoleInfo> listByCondition(TenantRolePageRequest request) {
        Response<PageResult<TenantRoleInfo>> pageInfoResponse = ClientUtils.executeHttpCall(this.inlongTenantRoleApi.listByCondition(request));
        ClientUtils.assertRespSuccess(pageInfoResponse);
        return (PageResult)pageInfoResponse.getData();
    }

    public int save(TenantRoleRequest record) {
        Response<Integer> saveResult = ClientUtils.executeHttpCall(this.inlongTenantRoleApi.save(record));
        ClientUtils.assertRespSuccess(saveResult);
        return (Integer)saveResult.getData();
    }

    public boolean update(TenantRoleRequest record) {
        Response<Boolean> updateResult = ClientUtils.executeHttpCall(this.inlongTenantRoleApi.update(record));
        ClientUtils.assertRespSuccess(updateResult);
        return (Boolean)updateResult.getData();
    }

    public TenantRoleInfo get(int id) {
        Response<TenantRoleInfo> tenantRoleInfoResponse = ClientUtils.executeHttpCall(this.inlongTenantRoleApi.get(id));
        ClientUtils.assertRespSuccess(tenantRoleInfoResponse);
        return (TenantRoleInfo)tenantRoleInfoResponse.getData();
    }

    public Boolean delete(int id) {
        Response<Boolean> tenantRoleInfoResponse = ClientUtils.executeHttpCall(this.inlongTenantRoleApi.delete(id));
        ClientUtils.assertRespSuccess(tenantRoleInfoResponse);
        return (Boolean)tenantRoleInfoResponse.getData();
    }
}

