/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.Atomic;
import org.mapdb.Fun;

public final class Bind {
    private Bind() {
    }

    public static void size(MapWithModificationListener map, final Atomic.Long sizeCounter) {
        if (sizeCounter.get() == 0L) {
            long size = map.sizeLong();
            if (sizeCounter.get() != size) {
                sizeCounter.set(size);
            }
        }
        map.addModificationListener(new MapListener(){

            public void update(Object key, Object oldVal, Object newVal) {
                if (oldVal == null && newVal != null) {
                    sizeCounter.incrementAndGet();
                } else if (oldVal != null && newVal == null) {
                    sizeCounter.decrementAndGet();
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValue(MapWithModificationListener<K, V> map, final Map<K, V2> secondary, final Fun.Function2<V2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(e.getKey(), fun.run(e.getKey(), e.getValue()));
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(key);
                } else {
                    secondary.put(key, fun.run(key, newVal));
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValues(MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K, V2>> secondary, final Fun.Function2<V2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                V2[] v = fun.run(e.getKey(), e.getValue());
                if (v == null) continue;
                for (V2 v2 : v) {
                    secondary.add(Fun.t2(e.getKey(), v2));
                }
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void update(K key, V oldVal, V newVal) {
                block12: {
                    block13: {
                        block11: {
                            if (newVal != null) break block11;
                            Object[] v = (Object[])fun.run(key, oldVal);
                            if (v == null) break block12;
                            for (Object object : v) {
                                secondary.remove(Fun.t2(key, object));
                            }
                            break block12;
                        }
                        if (oldVal != null) break block13;
                        Object[] v = (Object[])fun.run(key, newVal);
                        if (v == null) break block12;
                        for (Object object : v) {
                            secondary.add(Fun.t2(key, object));
                        }
                        break block12;
                    }
                    Object[] oldv = (Object[])fun.run(key, oldVal);
                    Object[] newv = (Object[])fun.run(key, newVal);
                    if (oldv == null) {
                        if (newv != null) {
                            void var8_23;
                            Object[] arr$ = newv;
                            int len$ = arr$.length;
                            boolean bl = false;
                            while (var8_23 < len$) {
                                Object v = arr$[var8_23];
                                secondary.add(Fun.t2(key, v));
                                ++var8_23;
                            }
                        }
                        return;
                    }
                    if (newv == null) {
                        void var8_25;
                        Object[] arr$ = oldv;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var8_25 < len$) {
                            Object v = arr$[var8_25];
                            secondary.remove(Fun.t2(key, v));
                            ++var8_25;
                        }
                        return;
                    }
                    HashSet<Object> hashes = new HashSet<Object>();
                    for (Object v : oldv) {
                        hashes.add(v);
                    }
                    for (Object v : newv) {
                        if (hashes.contains(v)) continue;
                        secondary.add(Fun.t2(key, v));
                    }
                    for (Object v : newv) {
                        hashes.remove(v);
                    }
                    for (Object e : hashes) {
                        secondary.remove(Fun.t2(key, e));
                    }
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.add(Fun.t2(fun.run(e.getKey(), e.getValue()), e.getKey()));
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(Fun.t2(fun.run(key, oldVal), key));
                } else if (oldVal == null) {
                    secondary.add(Fun.t2(fun.run(key, newVal), key));
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(Fun.t2(oldKey, key));
                    secondary.add(Fun.t2(newKey, key));
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final Map<K2, K> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(fun.run(e.getKey(), e.getValue()), e.getKey());
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(fun.run(key, oldVal));
                } else if (oldVal == null) {
                    secondary.put(fun.run(key, newVal), key);
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(oldKey);
                    secondary.put(newKey, key);
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKeys(MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                K2[] k2 = fun.run(e.getKey(), e.getValue());
                if (k2 == null) continue;
                for (K2 k22 : k2) {
                    secondary.add(Fun.t2(k22, e.getKey()));
                }
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void update(K key, V oldVal, V newVal) {
                block12: {
                    block13: {
                        block11: {
                            if (newVal != null) break block11;
                            Object[] k2 = (Object[])fun.run(key, oldVal);
                            if (k2 == null) break block12;
                            for (Object object : k2) {
                                secondary.remove(Fun.t2(object, key));
                            }
                            break block12;
                        }
                        if (oldVal != null) break block13;
                        Object[] k2 = (Object[])fun.run(key, newVal);
                        if (k2 == null) break block12;
                        for (Object object : k2) {
                            secondary.add(Fun.t2(object, key));
                        }
                        break block12;
                    }
                    Object[] oldk = (Object[])fun.run(key, oldVal);
                    Object[] newk = (Object[])fun.run(key, newVal);
                    if (oldk == null) {
                        if (newk != null) {
                            void var8_23;
                            Object[] arr$ = newk;
                            int len$ = arr$.length;
                            boolean bl = false;
                            while (var8_23 < len$) {
                                Object k22 = arr$[var8_23];
                                secondary.add(Fun.t2(k22, key));
                                ++var8_23;
                            }
                        }
                        return;
                    }
                    if (newk == null) {
                        void var8_25;
                        Object[] arr$ = oldk;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var8_25 < len$) {
                            Object k22 = arr$[var8_25];
                            secondary.remove(Fun.t2(k22, key));
                            ++var8_25;
                        }
                        return;
                    }
                    HashSet<Object> hashes = new HashSet<Object>();
                    for (Object k : oldk) {
                        hashes.add(k);
                    }
                    for (Object k2 : newk) {
                        if (hashes.contains(k2)) continue;
                        secondary.add(Fun.t2(k2, key));
                    }
                    for (Object k2 : newk) {
                        hashes.remove(k2);
                    }
                    for (Object e : hashes) {
                        secondary.remove(Fun.t2(e, key));
                    }
                }
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Set<Fun.Tuple2<V, K>> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Map<V, K> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V, C> void histogram(MapWithModificationListener<K, V> primary, final ConcurrentMap<C, Long> histogram, final Fun.Function2<C, K, V> entryToCategory) {
        MapListener listener = new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    Object category = entryToCategory.run(key, oldVal);
                    this.incrementHistogram(category, -1L);
                } else if (oldVal == null) {
                    Object category = entryToCategory.run(key, newVal);
                    this.incrementHistogram(category, 1L);
                } else {
                    Object newCat;
                    Object oldCat = entryToCategory.run(key, oldVal);
                    if (oldCat == (newCat = entryToCategory.run(key, newVal)) || oldCat.equals(newCat)) {
                        return;
                    }
                    this.incrementHistogram(oldCat, -1L);
                    this.incrementHistogram(oldCat, 1L);
                }
            }

            private void incrementHistogram(C category, long i) {
                Long newCount;
                Long oldCount;
                while (!((oldCount = (Long)histogram.get(category)) == null ? histogram.putIfAbsent(category, i) == null : histogram.replace(category, oldCount, newCount = Long.valueOf(oldCount + i)))) {
                }
            }
        };
        primary.addModificationListener(listener);
    }

    public static interface MapWithModificationListener<K, V>
    extends Map<K, V> {
        public void addModificationListener(MapListener<K, V> var1);

        public void removeModificationListener(MapListener<K, V> var1);

        public long sizeLong();
    }

    public static interface MapListener<K, V> {
        public void update(K var1, V var2, V var3);
    }
}

