/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.Permission;
import com.qcloud.cos.model.UinGrantee;
import com.qcloud.cos.region.Region;

public class SetGetBucketAclDemo {
    public static void setGetBucketAclDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        AccessControlList aclGet = cosclient.getBucketAcl(bucketName);
        System.out.println("bucket acl:" + aclGet.getOwner());
        System.out.println("bucket acl:" + (Object)((Object)aclGet.getCannedAccessControl()));
        for (Grant grant : aclGet.getGrantsAsList()) {
            System.out.println(grant.getGrantee().getIdentifier());
            System.out.println(grant.getGrantee().getTypeIdentifier());
            System.out.println((Object)grant.getPermission());
        }
        AccessControlList aclSet = new AccessControlList();
        Owner owner = new Owner();
        owner.setId("qcs::cam::uin/2000000000:uin/2000000000");
        aclSet.setOwner(owner);
        UinGrantee uinGrantee = new UinGrantee("qcs::cam::uin/100000000000:uin/100000000000");
        aclSet.grantPermission(uinGrantee, Permission.Read);
        aclSet.grantPermission(GroupGrantee.AllUsers, Permission.Read);
        cosclient.setBucketAcl(bucketName, aclSet);
        cosclient.setBucketAcl(bucketName, CannedAccessControlList.Private);
        System.out.println("===========================");
        aclGet = cosclient.getBucketAcl(bucketName);
        System.out.println("bucket acl:" + aclGet.getOwner());
        System.out.println("bucket acl:" + (Object)((Object)aclGet.getCannedAccessControl()));
        for (Grant grant : aclGet.getGrantsAsList()) {
            System.out.println(grant.getGrantee().getIdentifier());
            System.out.println(grant.getGrantee().getTypeIdentifier());
            System.out.println((Object)grant.getPermission());
        }
    }

    public static void main(String[] args) {
        SetGetBucketAclDemo.setGetBucketAclDemo();
    }
}

