/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadPart;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.transfer.RangeDownloadCallable;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.utils.CRC64;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResumableDownloadSubmitter {
    private static final Logger log = LoggerFactory.getLogger(ResumableDownloadSubmitter.class);
    private final COS cos;
    private final ExecutorService threadPool;
    private final GetObjectRequest req;
    private final DownloadImpl download;
    private final File destFile;
    private final RandomAccessFile destRandomAccessFile;
    private final FileChannel destFileChannel;
    private final int partSize;
    private final int multiThreadThreshold;
    private final TransferProgress transferProgress;
    private final ProgressListenerChain listener;
    private PersistableResumeDownload downloadRecord;
    private List<Future<DownloadPart>> futures = new ArrayList<Future<DownloadPart>>();
    private List<DownloadPart> skippedParts = new ArrayList<DownloadPart>();

    ResumableDownloadSubmitter(COS cos, ExecutorService threadPool, GetObjectRequest req, DownloadImpl download, File destFile, RandomAccessFile destRandomAccessFile, FileChannel destFileChannel, PersistableResumeDownload downloadRecord, int partSize, int multiThreadThreshold, TransferProgress transferProgress, ProgressListenerChain listener) {
        if (cos == null || threadPool == null || req == null || download == null || destFile == null || destRandomAccessFile == null || destFileChannel == null || downloadRecord == null) {
            throw new IllegalArgumentException("arguments in ResumableDownloadSubmitter must not be null");
        }
        this.cos = cos;
        this.threadPool = threadPool;
        this.req = req;
        this.download = download;
        this.destFile = destFile;
        this.destRandomAccessFile = destRandomAccessFile;
        this.destFileChannel = destFileChannel;
        this.downloadRecord = downloadRecord;
        this.partSize = partSize;
        this.multiThreadThreshold = multiThreadThreshold;
        this.transferProgress = transferProgress;
        this.listener = listener;
    }

    public void submit() throws Exception {
        long contentLength = Long.parseLong(this.downloadRecord.getContentLength());
        this.download.setState(Transfer.TransferState.InProgress);
        if (contentLength < (long)this.multiThreadThreshold) {
            throw new CosClientException("contentLenth " + contentLength + " < " + this.multiThreadThreshold + " should not use resumabledownload.");
        }
        long start = 0L;
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_STARTED_EVENT);
        while (contentLength > start) {
            long bytesToRead;
            long end = start + bytesToRead - 1L;
            String block = String.format("%d-%d", start, end);
            if (this.downloadRecord.hasDownloadedBlocks(block)) {
                int readBytes;
                long updateBytes;
                log.debug("part found in download record: " + block);
                CRC64 crc64 = new CRC64();
                byte[] buffer = new byte[10240];
                this.destRandomAccessFile.seek(start);
                for (bytesToRead = Math.min((long)this.partSize, contentLength - start); bytesToRead > 0L && (readBytes = this.destRandomAccessFile.read(buffer)) != -1; bytesToRead -= updateBytes) {
                    updateBytes = Math.min((long)readBytes, bytesToRead);
                    crc64.update(buffer, (int)updateBytes);
                }
                this.skippedParts.add(new DownloadPart(start, end, crc64.getValue()));
                this.transferProgress.updateProgress(end + 1L - start);
            } else {
                GetObjectRequest getObj = this.copyGetObjectRequest(this.req);
                getObj.setRange(start, end);
                if (this.threadPool.isShutdown()) {
                    SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
                    throw new CancellationException("TransferManager has been shutdown");
                }
                this.futures.add(this.threadPool.submit(new RangeDownloadCallable(this.cos, getObj, this.destFile, this.destFileChannel, this.downloadRecord)));
            }
            start = end + 1L;
        }
    }

    GetObjectRequest copyGetObjectRequest(GetObjectRequest origin) {
        GetObjectRequest dst = new GetObjectRequest(origin.getCOSObjectId());
        dst.setCosCredentials(origin.getCosCredentials());
        dst.setFixedEndpointAddr(origin.getFixedEndpointAddr());
        dst.setGeneralProgressListener(origin.getGeneralProgressListener());
        dst.setMatchingETagConstraints(origin.getMatchingETagConstraints());
        dst.setModifiedSinceConstraint(origin.getModifiedSinceConstraint());
        dst.setNonmatchingETagConstraints(origin.getNonmatchingETagConstraints());
        dst.setResponseHeaders(origin.getResponseHeaders());
        dst.setSSECustomerKey(origin.getSSECustomerKey());
        dst.setTrafficLimit(origin.getTrafficLimit());
        dst.setUnmodifiedSinceConstraint(origin.getUnmodifiedSinceConstraint());
        return dst;
    }

    List<Future<DownloadPart>> getFutures() {
        return this.futures;
    }

    List<DownloadPart> getSkippedParts() {
        return this.skippedParts;
    }
}

